#ifndef _CORE_TERMIOS_H_
#define _CORE_TERMIOS_H_

#include <core/termbits.h>
#include <core/types.h>
#include <core/ttydefaults.h>

/****************************************************************************************************************/

#define CCEQ(val, c)	(c == val ? val != _POSIX_VDISABLE : 0)

/****************************************************************************************************************
 *
 * Window/terminal size structure.  This information is stored by the kernel
 * in order to provide a consistent interface, but is not used by the kernel.
 *
 */
struct winsize {
  unsigned short  ws_row;         // rows, in characters
  unsigned short  ws_col;         // columns, in characters
  unsigned short  ws_xpixel;      // horizontal size, pixels
  unsigned short  ws_ypixel;      // vertical size, pixels
};

/****************************************************************************************************************
 *
 * Structure for transferring strings to tty layer
 *
 */
#ifdef __CORE4_VISIBLE

struct ttyname {
  char *buf;
  size_t bufsize;
};

#endif

/****************************************************************************************************************
 *
 * Predefined speeds
 *
 */
#define B0      0
#define B50     50
#define B75     75
#define B110    110
#define B134    134
#define B150    150
#define B200    200
#define B300    300
#define B600    600
#define B1200   1200
#define B1800   1800
#define B2400   2400
#define B4800   4800
#define B9600   9600
#define B19200  19200
#define B38400  38400
#define B57600  57600
#define B115200 115200
#define B230400 230400
#define B460800 460800
#define B921600 921600

/****************************************************************************************************************
 *
 * The termios structure with all the flags (Extended BSD style)
 *
 */
#ifndef ASSEMBLER

typedef unsigned int	tcflag_t;
typedef unsigned char	cc_t;
typedef unsigned int	speed_t;

struct termios {
  tcflag_t	c_iflag;	// input flags
  tcflag_t	c_oflag;	// output flags
  tcflag_t	c_cflag;	// control flags
  tcflag_t	c_lflag;	// local flags
  cc_t		c_cc[NCCS];	// control chars
  speed_t	c_ispeed;	// input speed
  speed_t	c_ospeed;	// output speed
  unsigned int  c_vmin;		// Extended VMIN from c_cc (larger values than 255)
  unsigned int  c_vtime;	// Extended VTIME from c_cc (larger values than 255, 1ms resolution)
};

#endif

/****************************************************************************************************************/
#endif
