#ifndef _CORE_SYSCALL_MMAP_H_ /**********************************************************************************/
#define _CORE_SYSCALL_MMAP_H_

/****************************************************************************************************************/

#include <core/types.h>
#include <core/syscall.h>

_syscall6(void *, mmap, void *, start, size_t, len, int, prot, int, flags, int, fd, off_t, offset);
_syscall2(int, munmap, void *, addr, size_t, len);

_syscall3(int, mprotect, void *, addr, size_t, len, int, prot);
_syscall3(int, msync, void *, addr, size_t, len, int, flags);
_syscall3(int, madvise, void *, start, size_t, length, int, advice);

_syscall2(int, mlock, const void *, addr, size_t, len);
_syscall2(int, munlock, const void *, addr, size_t, len);

_syscall1(int, mlockall, int, flags);
_syscall0(int, munlockall);

/****************************************************************************************************************/
#endif
