#ifndef _CORE_STATFS_H_
#define _CORE_STATFS_H_

/****************************************************************************************************************/

#include <core/fstypes.h>

/****************************************************************************************************************/

struct statfs {
  long    f_type;     /* Filesystem type			*/
  long    f_bsize;    /* Block size				*/
  long    f_blocks;   /* Total number of blocks			*/
  long    f_bfree;    /* free blocks				*/
  long    f_bavail;   /* free blocks avail to non-superuser	*/
  long    f_files;    /* total number of files in file system	*/
  long    f_ffree;    /* free file nodes in fs			*/
  fsid_t  f_fsid;     /* file system id				*/
  long    f_namelen;  /* maximum length of filenames		*/
};

/****************************************************************************************************************/
#endif
