#ifndef _CORE_SIGNR_H_ /**** USED BY LUA ************************************************************************/
#define _CORE_SIGNR_H_

/****************************************************************************************************************/

#define SIGHUP	   1	/* hangup */
#define SIGINT	   2	/* interrupt */
#define SIGQUIT    3	/* quit */
#define SIGILL	   4	/* illegal instruction (not reset when caught) */
#define SIGTRAP    5	/* trace trap (not reset when caught) */
#define SIGABRT    6	/* abort() */
#define SIGIOT	SIGABRT /* compatibility */
#define SIGEMT	   7	/* EMT instruction */
#define SIGFPE	   8	/* floating point exception */
#define SIGKILL    9	/* kill (cannot be caught or ignored) */
#define SIGBUS	  10	/* bus error */
#define SIGSEGV   11	/* segmentation violation */
#define SIGSYS	  12	/* bad argument to system call */
#define SIGPIPE   13	/* write on a pipe with no one to read it */
#define SIGALRM   14	/* alarm clock */
#define SIGTERM   15	/* software termination signal from kill */
#define SIGURG	  16	/* urgent condition on IO channel */
#define SIGSTOP   17	/* sendable stop signal not from tty */
#define SIGTSTP   18	/* stop signal from tty */
#define SIGCONT   19	/* continue a stopped process */
#define SIGCHLD   20	/* to parent on child stop or exit */
#define SIGTTIN   21	/* to readers pgrp upon background tty read */
#define SIGTTOU   22	/* like TTIN for output if (tp->t_local&LTOSTOP) */
#define SIGIO	  23	/* input/output possible signal */
#define SIGXCPU   24	/* exceeded CPU time limit */
#define SIGXFSZ   25	/* exceeded file size limit */
#define SIGVTALRM 26	/* virtual time alarm */
#define SIGPROF   27	/* profiling time alarm */
#define SIGWINCH  28	/* window size changes */
#define SIGINFO   29	/* information request */
#define SIGUSR1   30	/* user defined signal 1 */
#define SIGUSR2   31	/* user defined signal 2 */

/****************************************************************************************************************/

#define SIG_BLOCK          0		// Set (or) mask bits
#define SIG_UNBLOCK        1		// Clear mask bits
#define SIG_SETMASK        2		// Replace mask bits

/****************************************************************************************************************/

#define SA_NOCLDSTOP    0x00000001	// Turn off SIGCHLD when children stop
#define SA_NOCLDWAIT    0x00000002	// Flag on SIGCHLD to inhibit zombies
#define SA_RESTART      0x10000000	// Flag to get restarting signals
#define SA_NODEFER      0x40000000	// Prevents the current signal from being masked in the handler
#define SA_RESETHAND    0x80000000	// Clears the handler when the signal is delivered

#define SA_ONESHOT      SA_RESETHAND

/****************************************************************************************************************/
#endif
