#ifndef _CORE_PARAM_H_
#define _CORE_PARAM_H_

/********************************************************************************************************/

#define MACHINE_ARCH "arm"
#define _MACHINE_ARCH "arm"

/********************************************************************************************************/

/*
 * Round p (pointer or byte index) up to a correctly-aligned value
 * for all data types (int, long, ...).	  The result is u_int and
 * must be cast to any desired pointer type.
 *
 * ALIGNED_POINTER is a boolean macro that checks whether an address
 * is valid to fetch data elements of type t from on this architecture.
 * This does not reflect the optimal alignment, just the possibility
 * (within reasonable limits). 
 *
 */
#define ALIGNBYTES		(sizeof(int) - 1)
#define ALIGN(p)		(((unsigned int)(p) + ALIGNBYTES) &~ ALIGNBYTES)
#define ALIGNED_POINTER(p,t)	((((unsigned long)(p)) & (sizeof(t)-1)) == 0)

/********************************************************************************************************
 *
 * Limits for filesystem
 *
 */
#define PATH_MAX		1024
#define MAXPATHLEN		PATH_MAX
#define MAXSYMLINKS		32

/********************************************************************************************************
 *
 * OpenBSD sources want this, OpenBSD documents this macro as:
 *
 *   The file system is made out of blocks of at most MAXBSIZE units, with
 *   smaller units (fragments) only in the last direct block.  MAXBSIZE
 *   primarily determines the size of buffers in the buffer pool.  It may be
 *   made larger without any effect on existing file systems; however making
 *   it smaller makes some file systems unmountable.
 *
 * Core4 doesn't care about MAXBSIZE, so let's define it to something useful.
 *
 */
#ifndef MAXBSIZE
#define	MAXBSIZE	65536
#endif

/********************************************************************************************************
 *
 * OpenBSD defines these in param.h
 * ...but let's do it more safely.
 *
 */
#define MAX(a, b) ({ typeof(a) _a = (a); typeof(b) _b = (b); _a > _b ? _a : _b; })
#define MIN(a, b) ({ typeof(a) _a = (a); typeof(b) _b = (b); _a < _b ? _a : _b; })

/********************************************************************************************************
 *
 * OpenBSD defines these in param.h
 *
 */
#ifndef howmany
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif
#define	roundup(x, y)	((((x)+((y)-1))/(y))*(y))
#define powerof2(x)	((((x)-1)&(x))==0)

/********************************************************************************************************/

#define MAXHOSTNAMELEN	256		/* max hostname size */

/********************************************************************************************************/

#ifndef NULL
#define NULL 0L
#endif

/********************************************************************************************************/
#endif
