#ifndef _CORE_DIRENT_H_
#define _CORE_DIRENT_H_

/****************************************************************************************************************/

#include <core/types.h>

/****************************************************************************************************************/

struct dirent {
  ino_t d_ino;
  off_t d_off;
  unsigned short d_reclen;
  unsigned char d_type;
  unsigned char d_namlen;
  char d_name[256];
};

// This is simply (st.st_mode >> 12) & 15
#define	DT_UNKNOWN	 0
#define	DT_FIFO		 1
#define	DT_CHR		 2
#define	DT_DIR		 4
#define	DT_BLK		 6
#define	DT_REG		 8
#define	DT_LNK		10
#define	DT_SOCK		12

#define _DIRENT_HAVE_D_NAMLEN
#define _DIRENT_HAVE_D_RECLEN
#define _DIRENT_HAVE_D_OFF
#define _DIRENT_HAVE_D_TYPE

/****************************************************************************************************************/
#endif
