#ifndef _CORE_BYTESWAP_H_
#define _CORE_BYTESWAP_H_

/*
 * Copyright (c) 2007 Teratronik elektronische Systeme GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Teratronik GmbH nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY TERATRONIK GMBH ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TERATRONIK GMBH BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/****************************************************************************************************************/

#define __LITTLE_ENDIAN	1234
#define __BIG_ENDIAN	4321
#define __PDP_ENDIAN	3412
#define __BYTE_ORDER	__LITTLE_ENDIAN	/* Core4 is fixed to little endian. No holy wars, please. */

/****************************************************************************************************************/

static inline unsigned int __bswap_runtime_16(unsigned int x) __attribute__((always_inline));

static inline unsigned int __bswap_runtime_16(unsigned int x) {
  unsigned int tmp1, tmp2;

  asm ("/* __bswap_runtime_16 */\n"
       "	mov	%1,%0,lsl #24\n"		/* %0 = AABBCCDD -> %1 = DD000000			*/
       "	mov	%2,%0,lsl #16\n"		/* %0 = AABBCCDD -> %2 = CCDD0000			*/
       "	mov	%0,%2,lsr #24\n"		/* %2 = CCDD0000 -> %0 = 000000CC			*/
       "	orr	%0,%0,%1,lsr #16\n"		/* %0 = 000000CC -> %0 = 0000DDCC			*/
       : "=r"(x), "=r"(tmp1), "=r"(tmp2) : "0"(x));

  return x;
}

#define __bswap_constant_16(x)  ((((x) >> 8) & 0xFF) | (((x) & 0xFF) << 8))

#define __bswap16(x) (__extension__					\
      ({ register unsigned int __v, __x = (x);				\
	 if (__builtin_constant_p (__x))				\
	   __v = __bswap_constant_16 (__x);				\
	 else								\
	   __v = __bswap_runtime_16(__x);				\
	 __v; }))

/****************************************************************************************************************/

static inline unsigned int __bswap_runtime_32(unsigned int x) __attribute__((always_inline));

static inline unsigned int __bswap_runtime_32(unsigned int x) {

  unsigned int tmp;

  asm ("/* __bswap_runtime_32 */\n"
       "	eor	%1, %0, %0, ror #16\n"	/* This crazy piece is documented in the ARM reference manual	*/
       "	bic	%1, %1, #0x00FF0000\n"
       "	mov	%0, %0, ror #8\n"
       "	eor	%0, %0, %1, lsr #8\n"
       : "=r"(x), "=r"(tmp) : "0"(x));

  return x;
}

#define __bswap_constant_32(x)	((((x) & 0xff000000) >> 24) | (((x) & 0x00ff0000) >>  8) | \
				(((x) & 0x0000ff00) <<  8) | (((x) & 0x000000ff) << 24))

#define __bswap32(x) (__extension__					\
      ({ register unsigned int __v, __x = (x);				\
	 if (__builtin_constant_p (__x))				\
	   __v = __bswap_constant_32 (__x);				\
	 else								\
	   __v = __bswap_runtime_32(__x);				\
	 __v; }))

/****************************************************************************************************************/
#endif
