#include <lua/gpio.lh>

------------------------------------------------------------------------------------------------------------------
--
-- Change this to reflect your hardware configuration
--
-- RS485 on V4 1/2                         /dev/ttyS1
-- RS485 on a UART-B module on V4          /dev/ttyS7
-- uBus connector on V4                    /dev/mubus
--
#define MUPPDEVICE "/dev/ttyS7"

------------------------------------------------------------------------------------------------------------------
--
-- Initialize graphics display for printing information messages, if available.
-- All messages are also printed to the debug serial port.
--
fb = gfx.open()
if (fb) then
  fb:cls()
  fb:font(gfx.font("/usr/lib/fonts/6x8.lfn"))
  dbgtrm = fb:terminal()
  dbgtrm:write("\033[20h", "\033%G", "\033[?97l")  -- Autofeed, UTF8 mode, enable updates and redraw
end

function dbg(fmt, ...)
  local ok,txt = pcall(string.format, fmt, ...)
  if (dbgtrm) then dbgtrm:write(txt, "\n") end
  print(txt)
end

------------------------------------------------------------------------------------------------------------------
--
-- Event handler for gpio events
--
local function gpio_event(ev)
  local group = ev.group
  local evtyp = ev.type

  if (group == GPGRP_MUPP) then

    if (ev.type == GPIO_ACTIVE) then
      local info = gpio.info(ev.value)
      dbg("Device %d detected (%s)", ev.value, info.name)
    elseif (ev.type == GPIO_INACTIVE) then
      dbg("Device %d failed", ev.value)
    end

  elseif (group >= 1000) then

    if (evtyp == GPIO_OFF) then
      dbg("Input %u.%u is OFF", ev.group, ev.pin)
    elseif (evtyp == GPIO_ON) then
      dbg("Input %u.%u is ON", ev.group, ev.pin)
    elseif (evtyp == GPIO_FALLING) then
      dbg("Input %u.%u switched ON->OFF (rise=%u fall=%u)", group, ev.pin, ev.rising, ev.falling)
    elseif (evtyp == GPIO_RISING) then
      dbg("Input %u.%u switched OFF->ON (rise=%u fall=%u)", group, ev.pin, ev.rising, ev.falling)
    end

  end

end

------------------------------------------------------------------------------------------------------------------
--
-- Main application event handler
--
app = event.new()
shell = app:shell()

------------------------------------------------------------------------------------------------------------------
--
-- Register gpio event handler
--
gpevh = gpio.new(app, gpio_event)

------------------------------------------------------------------------------------------------------------------
--
-- Register device at address 1 and ask for input state change events on the first four inputs
--
gpio.register(1001, GPGRP_MUPP, MUPPDEVICE, 1)
gpio.watch(1001, 0, GPIO_WATCH_ANY)
gpio.watch(1001, 1, GPIO_WATCH_ANY)
gpio.watch(1001, 2, GPIO_WATCH_ANY)
gpio.watch(1001, 3, GPIO_WATCH_ANY)

------------------------------------------------------------------------------------------------------------------
--
-- Run the mainloop
--
while true do
  app:poll()
end

------------------------------------------------------------------------------------------------------------------
