/*
 * Copyright 2005 Computing Research Labs, New Mexico State University
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COMPUTING RESEARCH LAB OR NEW MEXICO STATE UNIVERSITY BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
 * OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _h_ucpgba
#define _h_ucpgba

/*
 * $Id: ucpgba.h,v 1.6 2004/12/07 23:56:54 mleisher Exp $
 */

#ifdef __cplusplus
extern "C" {
#endif

#undef __
#if defined(__STDC__) || defined(__cplusplus)
#define __(x) x
#else
#define __(x) ()
#endif

/***************************************************************************
 *
 * Macros and types.
 *
 ***************************************************************************/

/*
 * These are the direction values that can appear in render runs and render
 * strings.
 */
#define UCPGBA_LTR 0
#define UCPGBA_RTL 1
#define UCPGBA_DIRECTION_MASK 1

/*
 * Ask for some more transcoding
 */
#define UCPGBA_ARABIC_JOINING	4	// Perform arabic joining algorithm
#define UCPGBA_ARABIC_NUMBERS	8	// Translate ASCII digits to arabic digits
#define UCPGBA_LOGICAL_ORDER	16	// Do not reorder RTL, keep in logical order

/*
 * Allows to overide malloc/free
 *
 */
typedef struct _ucops_t {
  void *data;
  void *(*allocate)(void *data, size_t size);
  void (*deallocate)(void *data, void *ptr);
} ucops_t;

/*
 * This structure is used to contain runs of text in a particular direction.
 */
typedef struct _ucrun_t {
    struct _ucrun_t *prev;         /* Pointer to the previous run.           */
    struct _ucrun_t *next;         /* Pointer to the next run.               */

    int direction;                 /* Direction of the run.                  */

    unsigned long *chars;          /* List of characters for the run.        */
    unsigned int length;	   /* Number of visual characters in run     */
} ucrun_t;

/*
 * This represents a string of runs rendered up to a point that is not
 * platform specific.
 */
typedef struct _ucstring_t {
    int direction;                /* Overall direction of the string.       */

    unsigned int flags;		  /* Flags that where used during create    */

    ucrun_t *first;               /* First run in the list.                 */
    ucrun_t *last;                /* Last run in the list.                  */

    const ucops_t *ops;		  /* Memory allocation handlers		    */
} ucstring_t;

/***************************************************************************
 *
 * API
 *
 ***************************************************************************/

/*
 * This creates and reorders the specified substring using the
 * "Pretty Good Bidi Algorithm."  A default direction is provided for cases
 * of a string containing no strong direction characters.
 */
extern ucstring_t *ucstring_create __((const unsigned long *source,
                                       unsigned long length,
                                       unsigned int flags, const ucops_t *ops));

/*
 * This releases the string.
 */
extern void ucstring_free __((ucstring_t *string));

#undef __

#ifdef __cplusplus
}
#endif

#endif /* _h_ucpgba */
