#ifndef _SYS_WAIT_H_ /******************************************************************************************/
#define _SYS_WAIT_H_

/****************************************************************************************************************/

#include <core/wait.h>
#include <core/syscall/wait.h>

/****************************************************************************************************************/

__attribute__((__always_inline__)) static inline pid_t wait(int *status) {
  return wait4(-1, status, 0, 0);
}

__attribute__((__always_inline__)) static inline pid_t wait3(int *status, int options, struct rusage *rusage) {
  return wait4(-1, status, options, rusage);
}

__attribute__((__always_inline__)) static inline pid_t waitpid(pid_t pid, int *status, int options) {
  return wait4(pid, status, options, 0);
}

/****************************************************************************************************************/
#endif
