#ifndef LIBKEYBOARD_KEYBOARD_EVENT_H
#define LIBKEYBOARD_KEYBOARD_EVENT_H

/****************************************************************************************************************/

#include <sys/types.h>

struct keyboard_event {
  struct keyboard *keyboard;	// Keyboard instance this is coming from
  uint location;		// Source of event (e.g. USB location ID)
  uint scancode;		// Scancode of key
  uint value;			// KEYVAL_UP, KEYVAL_DOWN or KEYVAL_REPEAT
  uint modifiers;		// State of modifiers (Shift, Ctrl, ...)
  uint unicode;			// Unicode character, or ~0 if none available.
};

/****************************************************************************************************************/
//
// <value> field of struct keyboard_event
//
#define KEYVAL_DOWN	0
#define KEYVAL_UP	1
#define KEYVAL_REPEAT	2

/****************************************************************************************************************/
#endif
