#ifndef OBJECT_H /******************************************************************************** -*- c++ -*- **/
#define OBJECT_H

/****************************************************************************************************************/

class Timer;
class Event;

/****************************************************************************************************************/

class Object {
public:
  Object(Object *par = 0, const char *n = 0);
  virtual ~Object();

public:
  void deleteChildren(void);
  void addChildren(Object *ob);
  void removeChildren(Object *ob);
  void reparent(Object *par);
  const char *name(void) const;
  void setName(const char *txt);
  void deleteLater(void);

public:
  void sendEvent(Object *receiver, Event *ev);
  void sendEventToChildren(Event *ev);
  virtual void event(Object *sender, Event *ev);

public:
  Object *parent(void) const      { return m_parent;       }
  Object *firstChild(void) const  { return m_first_child;  }
  Object *lastChild(void) const;
  Object *nextSibling(void) const { return m_next_sibling; }
  Object *prevSibling(void) const { return m_prev_sibling; }
  unsigned int numChildren(void) const;

public:
  virtual bool isWidget(void) const;

protected:
  const char *tr(const char *txt, const char *comment = 0) { return txt; } // Stub for implementing i18n later

  virtual void childRemoved(Object *obj); // callback
  virtual void childAdded(Object *obj); // callback

protected:
  friend class Timer;
  virtual void timeout(Timer *t);

public:
  virtual void dump(unsigned int spaces = 0);
  virtual void dumpChildren(unsigned int spaces = 0);

  void trace(const char *fmt, ...);

private:
  void event(Object *sender, Event *ev, bool top);

private:
  Object *m_parent;
  Object *m_next_sibling;
  Object *m_prev_sibling;
  Object *m_first_child;
  char *m_name;
};

/****************************************************************************************************************/

#endif
