#ifndef DESCRIPTORLIST_H /************************************************************************ -*- c++ -*- **/
#define DESCRIPTORLIST_H

/****************************************************************************************************************/

#include "object.h"
#include <sys/types.h>
#include <poll.h>

/****************************************************************************************************************/

class Descriptor;

class DescriptorList : public Object {

public: // Construction
  DescriptorList(Object *par = 0, const char *n = 0);
  virtual ~DescriptorList();

public: // Read/write signal activation
  void disableAll(int fd);
  void enableRead(int fd, Descriptor *d, bool en);
  void enableWrite(int fd, Descriptor *d, bool en);
  bool readEnabled(int fd);
  bool writeEnabled(int fd);

public: // poll() call preparation
  struct pollfd *files(void)         { return m_poll;  }
  unsigned int filecount(void) const { return m_count; }
  void poll(void);

public:
  void showReadList(void);
  void showWriteList(void);

  enum { maxPoll = 128 };

private:
  int find(int fd);
  int install(int fd, Descriptor *d);

private:
  struct pollfd m_poll[maxPoll];
  Descriptor *m_descriptors[maxPoll];
  unsigned int m_count;
};

/****************************************************************************************************************/

extern DescriptorList AppDescriptorList;

/****************************************************************************************************************/

#endif
