#ifndef TTN_LINUX_MEMDUMP_H
#define TTN_LINUX_MEMDUMP_H
/********************************************************************************************************/

#include "ttn/ttn.h"

#include <stdint.h>

/********************************************************************************************************/

#define MEMDUMP_MODE_8BIT      0
#define MEMDUMP_MODE_16BIT_LE  1
#define MEMDUMP_MODE_16BIT_BE  2
#define MEMDUMP_MODE_32BIT_LE  3
#define MEMDUMP_MODE_32BIT_BE  4

typedef const char *memdump_highlighter_t(uintptr_t addr);

struct memdump_request {
  const void *start;
  uintptr_t at;
  size_t count;
  unsigned int mode;
  const char *pfx;
  memdump_highlighter_t *highlighter;
  const char *color;
};

void ttn_glue_memdump_generic(int level, const struct memdump_request *rq);

/********************************************************************************************************/
#endif
