#ifndef _CORE_MMAN_H_
#define _CORE_MMAN_H_

/****************************************************************************************************************/

#define MAP_FAILED	((void *) -1)

/****************************************************************************************************************/

#define PROT_NONE	0x00
#define PROT_READ	0x01
#define PROT_WRITE	0x02
#define PROT_EXEC	0x04

#define PROT_UNCACHED	0x10000000
#define PROT_UNBUFFERED	0x20000000

/****************************************************************************************************************/

#define MAP_SHARED	0x01
#define MAP_PRIVATE	0x02

/****************************************************************************************************************/

#define MAP_FILE	0x00
#define MAP_FIXED	0x10
#define MAP_ANONYMOUS	0x20
#define MAP_ANON	MAP_ANONYMOUS
#define MAP_POPULATE	0x8000

/****************************************************************************************************************/

#define	MADV_NORMAL	0	// no further special treatment
#define	MADV_RANDOM	1	// expect random page references
#define	MADV_SEQUENTIAL	2	// expect sequential page references
#define	MADV_WILLNEED	3	// will need these pages
#define	MADV_DONTNEED	4	// dont need these pages
#define	MADV_SPACEAVAIL	5	// insure that resources are reserved
#define	MADV_FREE	6	// pages are empty, free them

/****************************************************************************************************************/

#define MS_ASYNC	1
#define MS_INVALIDATE	2
#define MS_SYNC		4

/****************************************************************************************************************/

#define MCL_CURRENT	1
#define MCL_FUTURE	2

/****************************************************************************************************************/
#endif
