#ifndef _CORE_KCONFIG_H_
#define _CORE_KCONFIG_H_

#include <core/types.h>

/****************************************************************************************************************/

struct kconfig_request {
  uint32 *krq_path;				// List of tags pointing to the entry
  unsigned int krq_path_count;			// Number of tags in path
  void *krq_data;				// Buffer for data
  unsigned int krq_data_size;			// Size of buffer
};

/****************************************************************************************************************/

#define KCONFIG_QUERY_VALUE		0x5200	// Read an entry

#define KCONFIG_SET_VALUE		0x5280	// Set/create an entry
#define KCONFIG_DELETE			0x5281	// Delete an entry (To delete a section, it must be empty)

/****************************************************************************************************************/
//
// Data types
//
#define KCONFIG_TYPE_BINARY		0x00
#define KCONFIG_TYPE_INTEGER		0x01
#define KCONFIG_TYPE_BOOL		0x02
#define KCONFIG_TYPE_STRING		0x03
#define KCONFIG_TYPE_DATE		0x04
#define KCONFIG_TYPE_TIME		0x05
#define KCONFIG_TYPE_DATETIME		0x06
#define KCONFIG_TYPE_BITARRAY		0x07
#define KCONFIG_TYPE_INT64		0x08

#define KCONFIG_TYPE_ENUM		0x10
#define KCONFIG_TYPE_UINT		0x11
#define KCONFIG_TYPE_IP4ADDR		0x14
#define KCONFIG_TYPE_MAC		0x15
#define KCONFIG_TYPE_IP6ADDR		0x16
#define KCONFIG_TYPE_UINT64		0x18
#define KCONFIG_TYPE_PASSWORD		0x19

#define KCONFIG_TYPE_POINT   	 	0x20
#define KCONFIG_TYPE_RECT    		0x21
#define KCONFIG_TYPE_SIZE		0x22

#define KCONFIG_TYPE_SECTION		0xFF

#define KCONFIG_TYPE(key) ((key) >> 24)

/****************************************************************************************************************/
#endif
