#!/usr/bin/perl

use Getopt::Long;

################################################################################
#
# Generates top makefile rules for ARM code
#
# Looks for a file SOURCES in every subdirectory
# Builds a Makefile.inc that compiles all of the sources
#
my $host;
my $dir;
my @sources;
my @excludes;

GetOptions("host|h"		=> \$host,     # When present, generate rules for compiling a host binary
	   "dir|d=s"		=> \$dir,      # Indicates directory to scan for */SOURCES
	   "exclude|x=s"	=> \@excludes, # Patterns to exclude
	   "sources|s=s"	=> \@sources); # Indicates specific SOURCES files

################################################################################

if ($host) {
    $objdir = "host";
} else {
    $objdir = "obj";
}

################################################################################
################################################################################
#####									   #####
##### Process SOURCES file						   #####
#####									   #####
################################################################################
################################################################################

sub scansrc($) {
    my $dir = shift;

    my $lib = "";

    # See if SOURCES contains a line "LIB = ..."
    open(SRCHNDL,"<","$dir/SOURCES") || die("Cannot open $dir/SOURCES");
    foreach my $line (<SRCHNDL>) {
	if ($line =~ /^[ \t]*LIB[ \t]*=[ \t]*(.*)/) {
	    $lib = $1;
	    last;
	}
    }
    close(SRCHNDL);

    if ($lib ne "") {
	$apps = "$apps $dir/$objdir/$lib";
    } else {
	my $app = $dir;
	$app =~ s/.*\///;
	$apps = "$apps $dir/$objdir/$app";
    }

    mkdir("$dir/$objdir");
}

################################################################################
################################################################################
#####									   #####
##### Build list							   #####
#####									   #####
################################################################################
################################################################################

foreach my $dir (@sources) {
    $dir =~ s/\/SOURCES//g;
    push @dirs, $dir;
}

if ($dir || !$sources) {

    # Drop that dot
    if ($dir eq ".") { $dir = ""; }

    # Dir must end with a slash
    if ($dir && !($dir =~ /\/$/)) { $dir = "$dir/"; }

    $tmp = `ls $dir*/SOURCES`;
    $tmp =~ s/\/SOURCES//g;

    push @dirs, split("\n", $tmp);
}

################################################################################
################################################################################
#####									   #####
##### Generate APPS line						   #####
#####									   #####
################################################################################
################################################################################

$apps = "";

foreach $dir (@dirs) {

    foreach $excl (@excludes) {
	if ($dir eq $excl) {
	    $dir = "";
	    last;
	}
    }

    next if ($dir eq "");

    scansrc($dir);
}

print "APPS += $apps\n";
print "\n";

################################################################################
################################################################################
#####									   #####
##### Generate include statements					   #####
#####									   #####
################################################################################
################################################################################

foreach $dir (@dirs) {
    next if ($dir eq "");
    print "-include $dir/$objdir/Makefile.inc\n";
}
print "\n";

################################################################################
################################################################################
#####									   #####
##### Generate makefile generating statements				   #####
#####									   #####
################################################################################
################################################################################

if ($host) {
    $mkappargs = "-h";
} else {
    $mkappargs = "";
}

foreach $dir (@dirs) {
    next if ($dir eq "");
    print "$dir/$objdir/Makefile.inc: $dir/SOURCES \$(C4SDK)/scripts/c4makeapprules.pl Makefile.inc\n";
    print "\t\$(C4SDK)/scripts/c4makeapprules.pl $mkappargs -d $dir >$dir/$objdir/Makefile.inc\n";
    print "\n";
}

print "\n";
