#ifndef _LIBTOUCH_STRUCTURES_H_
#define _LIBTOUCH_STRUCTURES_H_

/****************************************************************************************************************/

#include <sys/types.h>
#include <core/touch.h>

/****************************************************************************************************************/

struct touch_state {
  int x;
  int y;
  int pressure;
  uint buttons;
};

// Mouse buttons
#define TBTN_LEFT_MOUSE		0x00000001
#define TBTN_RIGHT_MOUSE	0x00000002
#define TBTN_MIDDLE_MOUSE	0x00000004

// Touch "buttons"
#define TBTN_PEN		0x00010000	// LEFT_MOUSE << 16
#define TBTN_FINGER		0x00020000	// RIGHT_MOUSE << 16

/****************************************************************************************************************/

struct touch_calib {
  int A, B, C, W;	// Xd = A * X + B * Y - C	0 <= Xd < W
  int D, E, F, H;	// Yd = D * X + E * Y - F	0 <= Yd < H
  int penthr;
  int fingerthr;
  uint flags;
  uint orientation;
};

/****************************************************************************************************************/
#endif
