#ifndef _LIBKEYBOARD_POST_H_
#define _LIBKEYBOARD_POST_H_

/****************************************************************************************************************/

#include <sys/types.h>
#include <sys/cdefs.h>

__BEGIN_DECLS

/****************************************************************************************************************/

struct keyboard_post_handle;

struct keyboard_post_handle *keyboard_post_open(void);
void keyboard_post_close(struct keyboard_post_handle *tph);

int keyboard_post_event(struct keyboard_post_handle *tph, uint code, int value);
int keyboard_post_down_up(struct keyboard_post_handle *kph, uint code);

// 0x0007xxxx --> USB HID scancodes.
//   The keyboard decoder subjects this to a mapping for the configured keyboard language.
#define KEYBOARD_POST_SCANCODE(x) ((x) | 0x00070000)

// 0x0009xxxx --> Buttons
//   Used by 4x4 matrix keypads, typical x values are 1...16
//   The keyboard decoder has a configurable mapping table that maps buttons to unicode.
//   By default, this map is loaded with a mapping for a number pad.
#define KEYBOARD_POST_BUTTON(x)   ((x) | 0x00090000)

// 0x0010xxxx --> Direct Unicode
#define KEYBOARD_POST_UNICODE(x)  ((x) | 0x00100000)


/****************************************************************************************************************/
__END_DECLS
#endif
