#ifndef _CORE_MODELINE_H_
#define _CORE_MODELINE_H_

/****************************************************************************************************************/

#include <core/types.h>

/****************************************************************************************************************/

struct fbdev_modeline {
  uint32 pclk;

  uint16 hdisp;
  uint16 hsyncstart;
  uint16 hsyncend;
  uint16 htotal;

  uint16 vdisp;
  uint16 vsyncstart;
  uint16 vsyncend;
  uint16 vtotal;

  uint32 flags;
};

/****************************************************************************************************************/

// modeline flags from EDID
#define MODELINE_HPOS			0	// HSYNC polarity
#define MODELINE_HNEG			(1<<0)

#define MODELINE_VPOS			0	// VSYNC polarity
#define MODELINE_VNEG			(1<<1)

#define MODELINE_INTERLACE		(1<<2)	// Interlace mode

#define MODELINE_DOUBLESCAN		(1<<3)	// Double scan mode

#define MODELINE_PREFERRED		(1<<4)	// This modeline is a preferred modeline for the display

// Nonstandard modeline flags
#define MODELINE_DEPOS			0	// Data enable polarity
#define MODELINE_DENEG			(1<<8)

#define MODELINE_CLKPOS			0	// Dotclock polarity
#define MODELINE_CLKNEG			(1<<9)

#define MODELINE_DATPOS			0	// Video data polarity
#define MODELINE_DATNEG			(1<<10)

#define MODELINE_CLOCKGATED		(1<<11)	// Clock is being driven only when DE is activea

#define MODELINE_18SHIFTED		(1<<16)	// Weirdly wired up LVDS converter that needs color bits shifted.
#define MODELINE_EXTRALINE		(1<<17)	// Display needs one additional invisible line clocked in
#define MODELINE_BGR			(1<<18)	// Colors are reversed

/****************************************************************************************************************/
#endif
