#ifndef LIBTTN_PKB_H
#define LIBTTN_PKB_H
/****************************************************************************************************************/

#include "ttn/ttn.h"
#include "ttn/lnk/pkb.h"
#include "ttn/lnk/packet.h"

/****************************************************************************************************************/

static inline struct ttn_packet_t *ttn_pkb_packet(ttn_pkb_t *pkb) {
  return (struct ttn_packet_t *)((uintptr_t)pkb->pkb_link - TTN_PACKET_PREFIX);
}

/****************************************************************************************************************/

static inline bool ttn_pkb_eth_is_broadcast_dst(ttn_pkb_t *pkb) {
  const uint16_t *lnk = (const uint16_t *)(uintptr_t)pkb->pkb_link;
  return (lnk[0] == 0xFFFF) && (lnk[1] == 0xFFFF) && (lnk[2] == 0xFFFF);
}

static inline bool ttn_pkb_ttn_is_broadcast_dst(ttn_pkb_t *pkb) {
  struct ttn_packet_t *pkt = ttn_pkb_packet(pkb);
  return pkt->did == 0;
}

/****************************************************************************************************************/

void ttn_update_udp_checksum(ttn_pkb_t *pkb);
void ttn_update_ip_checksum(ttn_pkb_t *pkb);

/****************************************************************************************************************/
#endif
