#ifndef LIBTTN_ETH_BRIDGE_HANDLE_H
#define LIBTTN_ETH_BRIDGE_HANDLE_H
/****************************************************************************************************************/
//
// THIS FILE IS PRIVATE TO TTN.
//
// Included publicly to facilitate function inlining.
// Please behave. Having to wrap everything in a TTN_PRIVATE() macro like MbedTLS does is ugly.
//
/****************************************************************************************************************/

struct ttn_bridge_handle_t {
  struct ttn_lnk_handle_t *ttb_ttn;                // Instance that handles the TTN network layer
  ttn_timerqueue_t *ttb_tmq;                       // Timer management
  int ttb_tracelevel;                              // Debugging configuration
  const struct ttn_bridge_operations_t *ttb_ops;   // Callbacks to local implementation
  void *ttb_lcl_data;                              // Callback's argument
  uint8_t ttb_lcl_mac[6];                          // Local MAC address
  ttn_timer_t ttb_timer;                           // Housekeeping timer
  struct ttn_mac_cache_t ttb_mactable;             // Keep track of MAC addresses vs. TID addresses
  struct ttn_bridge_stats ttb_stats;               // Statistics
};

/****************************************************************************************************************/
#endif
