#ifndef LIBTTN_TTN_ARP_H
#define LIBTTN_TTN_ARP_H
/****************************************************************************************************************/

#include "ttn/ttn.h"

#include <stdbool.h>

// In memory data structure. Does not match any on-wire message format.
struct ttn_lnk_arp_t {
  uint32_t sender_ip;
  uint32_t target_ip;
  uint8_t sender_mac[6];
  uint8_t target_mac[6];
  uint8_t opcode;
};

#define ARP_OP_QUERY  1
#define ARP_OP_REPLY  2

bool ttn_lnk_decode_arp(struct ttn_lnk_arp_t *amsg, const ttn_pkb_t *pkb);
bool ttn_lnk_encode_arp(const struct ttn_lnk_arp_t *amsg, ttn_pkb_t *pkb);

/****************************************************************************************************************/
#endif
