#ifndef _CORE_TOUCH_H_
#define _CORE_TOUCH_H_

#include <core/types.h>
#include <core/touchbits.h>

/****************************************************************************************************************
 *
 * API for the touch screen calibration non-volatile storage
 *
 * When TOUCHCAL_STATIC is _not_ set:
 *
 *    Xd = A * X + B * Y - C
 *    Yd = D * X + E * Y - F
 *
 * When TOUCHCAL_STATIC is set:
 *
 *    X spans the whole display and runs from C ... (A+C-1)
 *    Y spans the whole display and runs from F ... (E+F-1)
 *
 */
struct touch_calibration {
  int16 A;		// Xd = A * X + B * Y - C
  int16 B;
  int16 C;
  int16 D;		// Yd = D * X + E * Y - F
  int16 E;
  int16 F;
  int16 penthr;		// Pen pressure threshold
  int16 fingerthr;	// Finger pressure threshold
  uint16 flags;		// Flags
  uint16 panelid;	// Used to detect surprise change of display type
};

/****************************************************************************************************************/
#endif
