#ifndef _CORE_TERMBITS_H_ /**** USED BY LUA *********************************************************************/
#define _CORE_TERMBITS_H_

/****************************************************************************************************************
 *
 * Special Control Characters (From OpenBSD)
 *
 * Index into c_cc[] character array.
 *
 *	Name	     Subscript	Enabled by
 */
#define	VEOF		0	/* ICANON */
#define	VEOL		1	/* ICANON */
#define	VEOL2		2	/* ICANON */
#define	VERASE		3	/* ICANON */
#define VWERASE 	4	/* ICANON */
#define VKILL		5	/* ICANON */
#define	VREPRINT 	6	/* ICANON */
/*			7	   spare 1 */
#define VINTR		8	/* ISIG */
#define VQUIT		9	/* ISIG */
#define VSUSP		10	/* ISIG */
#define VDSUSP		11	/* ISIG */
#define VSTART		12	/* IXON, IXOFF */
#define VSTOP		13	/* IXON, IXOFF */
#define	VLNEXT		14	/* IEXTEN */
#define	VDISCARD	15	/* IEXTEN */
#define VMIN		16	/* !ICANON */
#define VTIME		17	/* !ICANON */
#define VSTATUS		18	/* ICANON */
/*			19	   spare 2 */
#define	NCCS		20

#define _POSIX_VDISABLE	(0xFF)

/****************************************************************************************************************
 *
 * Input flags - software input processing (From OpenBSD)
 *
 */
#define	IGNBRK		0x00000001	/* ignore BREAK condition */
#define	BRKINT		0x00000002	/* map BREAK to SIGINTR */
#define	IGNPAR		0x00000004	/* ignore (discard) parity errors */
#define	PARMRK		0x00000008	/* mark parity and framing errors */
#define	INPCK		0x00000010	/* enable checking of parity errors */
#define	ISTRIP		0x00000020	/* strip 8th bit off chars */
#define	INLCR		0x00000040	/* map NL into CR */
#define	IGNCR		0x00000080	/* ignore CR */
#define	ICRNL		0x00000100	/* map CR to NL (ala CRMOD) */
#define	IXON		0x00000200	/* enable output flow control */
#define	IXOFF		0x00000400	/* enable input flow control */
#define	IXANY		0x00000800	/* any char will restart after stop */
#define	IUCLC		0x00001000	/* translate upper to lower case */
#define IMAXBEL		0x00002000	/* ring bell on input queue full */
#define IUTF8		0x00004000	/* Input is UTF8 (From Linux, not implemented) */

/****************************************************************************************************************
 *
 * Output flags - software output processing (From OpenBSD)
 *
 */
#define	OPOST		0x00000001	/* enable following output processing */
#define ONLCR		0x00000002	/* map NL to CR-NL (ala CRMOD) */
#define OXTABS		0x00000004	/* expand tabs to spaces */
#define ONOEOT		0x00000008	/* discard EOT's (^D) on output */
#define OCRNL		0x00000010	/* map CR to NL */
#define OLCUC		0x00000020	/* translate lower case to upper case */
#define ONOCR		0x00000040	/* No CR output at column 0 */
#define ONLRET		0x00000080	/* NL performs the CR function */

/****************************************************************************************************************
 *
 * Control flags - hardware control of terminal
 *
 */
#define CSIZE		0x00000300	/* character size mask							*/
#define  CS5		 0x00000000	    /* 5 bits */
#define  CS6		 0x00000100	    /* 6 bits */
#define  CS7		 0x00000200	    /* 7 bits */
#define  CS8		 0x00000300	    /* 8 bits */
#define CSTOPB		0x00000400	/* send 2 stop bits							*/
#define CREAD		0x00000800	/* enable receiver							*/
#define PARENB		0x00001000	/* parity enable							*/
#define PARODD		0x00002000	/* odd parity, else even						*/
#define HUPCL		0x00004000	/* hang up on last close						*/
#define CLOCAL		0x00008000	/* ignore modem status lines						*/
#define CCTS_OFLOW	0x00010000	/* CTS flow control of output						*/
#define CRTS_IFLOW	0x00020000	/* RTS flow control of input						*/
#define CRTSCTS		(CCTS_OFLOW | CRTS_IFLOW)
#define	CDTR_IFLOW	0x00040000	/* DTR flow control of input						*/
#define CDSR_OFLOW	0x00080000	/* DSR flow control of output						*/
#define MDMBUF		(CDTR_IFLOW | CDSR_OFLOW)
#define	CCAR_OFLOW	0x00100000	/* DCD flow control of output						*/
#define CHALF		0x00200000	/* Use half duplex mode (Disable receiver while transmitting)		*/
#define C485		0x00400000	/* Use RS485 driver control, using RTS or DTR (see XXX_IFLOW)		*/
#define CMSPAR          0x00800000      /* Add fixed parity bit                                                 */

/****************************************************************************************************************
 *
 * "Local" flags - dumping ground for other state (From OpenBSD)
 *
 * Warning: some flags in this structure begin with
 * the letter "I" and look like they belong in the
 * input flag.
 *
 */
#define	ECHOKE		0x00000001	/* visual erase for line kill */
#define	ECHOE		0x00000002	/* visually erase chars */
#define	ECHOK		0x00000004	/* echo NL after line kill */
#define ECHO		0x00000008	/* enable echoing */
#define	ECHONL		0x00000010	/* echo NL even if ECHO is off */
#define	ECHOPRT		0x00000020	/* visual erase mode for hardcopy */
#define ECHOCTL  	0x00000040	/* echo control chars as ^(Char) */
#define	ISIG		0x00000080	/* enable signals INTR, QUIT, [D]SUSP */
#define	ICANON		0x00000100	/* canonicalize input lines */
#define ALTWERASE	0x00000200	/* use alternate WERASE algorithm */
#define	IEXTEN		0x00000400	/* enable DISCARD and LNEXT */
#define EXTPROC         0x00000800      /* external processing */
#define TOSTOP		0x00400000	/* stop background jobs from output */
#define FLUSHO		0x00800000	/* output being flushed (state) */
#define XCASE		0x01000000	/* canonical upper/lower case */
#define	NOKERNINFO	0x02000000	/* no kernel output from VSTATUS */
#define PENDIN		0x20000000	/* XXX retype pending input (state) */
#define	NOFLSH		0x80000000	/* don't flush after interrupt */

/****************************************************************************************************************
 *
 * Commands passed to tcsetattr() for setting the termios structure.
 *
 */
#define	TCSANOW		0		/* make change immediate	*/
#define	TCSADRAIN	1		/* drain output, then change	*/
#define	TCSAFLUSH	2		/* drain output, flush input	*/

/****************************************************************************************************************
 *
 * More constants
 *
 */
#define	TCIFLUSH	1
#define	TCOFLUSH	2
#define TCIOFLUSH	3

#define	TCOOFF		1
#define	TCOON		2

#define TCIOFF		3
#define TCION		4

/****************************************************************************************************************
 *
 * More constants
 *
 */
#define TIOCM_LE	0x00001		/* Line Enable			*/
#define TIOCM_DTR       0x00002		/* Data terminal ready		*/
#define TIOCM_RTS       0x00004		/* Request to send		*/
#define TIOCM_ST	0x00008		/* Secondary Transmit		*/
#define TIOCM_SR	0x00010		/* Secondary Receive		*/
#define TIOCM_CTS       0x00020		/* Clear to send		*/
#define TIOCM_CAR       0x00040		/* Data carrier detect		*/
#define TIOCM_RNG       0x00080		/* Ring indicator		*/
#define TIOCM_DSR       0x00100		/* Data set ready		*/
#define TIOCM_TXD	0x10000		/* Transmit data		*/
#define TIOCM_RXD	0x20000		/* Receive data			*/

#define TIOCM_CD        TIOCM_CAR
#define TIOCM_RI        TIOCM_RNG

/****************************************************************************************************************
 *
 * TTY ioctl codes
 *
 */
#define TCGETS		0x5401		/* struct termios		*/
#define TCSETS		0x5402		/* const struct termios		*/
#define TCSETSW		0x5403		/* const struct termios		*/
#define TCSETSF		0x5404		/* const struct termios		*/
#define TCGETCONFSPEED	0x5405		/* int (configured speed)	*/

#define TCSBRK		0x5409		/* int				*/
#define TCXONC		0x540A		/* int				*/
#define TCFLSH		0x540B		/* int				*/

#define TIOCSTART	0x540C
#define TIOCSTOP	0x540D
			  	   
#define TIOCMGET	0x5415		/* int				*/
#define TIOCMBIS	0x5416		/* const int			*/
#define TIOCMBIC	0x5417		/* const int			*/
#define TIOCMSET	0x5418		/* const int			*/

#define TCSBRKP		0x5425		/* int				*/
#define TIOCEXT		0x5426		/* int				*/
#define TIOCSCTTY	0x5427		/* -/-				*/
#define TIOCNOTTY	0x5428		/* -/-				*/
#define TIOCGNAME	0x5429		/* char [TTY_NAME_MAX]		*/
#define TIOCGDEV	0x542A		/* char [TTY_NAME_MAX]		*/

#define TIOCGWINSZ	0x5431		/* struct winsize		*/
#define TIOCSWINSZ	0x5432		/* const struct winsize		*/

#define TIOCGETD	0x5433		/* int				*/
#define TIOCSETD	0x5434		/* int				*/

#define TIOCGPGRP	0x5435		/* int				*/
#define TIOCSPGRP	0x5436		/* int				*/

#define TIOCINQ		0x5437		/* int *			*/
#define TIOCOUTQ	0x5438		/* int *			*/

#define TIOCGETP	0x5439		/* int				*/
#define TIOCSETP	0x543A		/* int				*/

/****************************************************************************************************************
 *
 * Core4 specific ioctl codes
 *
 */
#ifdef __CORE4_VISIBLE

#define TIOCSET_HWADDR		  0x5480
#define TIOCGET_HWADDR		  0x5481

#define TIOCGET_BLK_FLAGS	  0x5490	/* Read status flags from driver */
#define TIOCSET_BLK_MODE	  0x5491	/* Set mode bits		 */
#define TIOCGET_BLK_MODE	  0x5492	/* Get mode bits		 */

#define TIOCGET_DIPS		  0x54A0	/* Read dip switches		 */

#define TIOCSET_TTN_BRIDGE_IF     0x54B0        /* Bridge with another interface */
#define TIOCSET_TTN_LINK_DEBUG    0x54B1        /* Set TTN Debuglevel            */
#define TIOCSET_TTN_BRIDGE_DEBUG  0x54B2        /* Set TTN Debuglevel            */
#define TIOCSET_TTN_MAC_DEBUG     0x54B3        /* Set TTN Debuglevel            */
#define TIOC_TTN_BUZZ             0x54B4        /* Send BUZZ request             */
#define TIOC_TTN_PROBE            0x54B5        /* Attempt to become prober      */
#define TIOCGET_TTN_STATS         0x54B6        /* Read TTN statistics           */
#define TIOCGET_TTN_PEERS         0x54B7        /* Read TTN peer list            */
#define TIOCGET_TTN_STATE         0x54B8        /* Read current state            */
#define TIOCGET_TTN_EVENT         0x54B9        /* Read status event             */
#define TIOCSET_TTN_EVENT         0x54BA        /* Enable/Disable events         */

#define TIOCSET_DEBUG             0x54FF        /* Set trace level               */

#endif

/****************************************************************************************************************
 *
 * Core4 specific blocknet definitions
 *
 */
#ifdef __CORE4_VISIBLE

#define BLK_STATUS_STAT_SENT		0x0001
#define BLK_STATUS_STAT_RECEIVED	0x0002
#define BLK_STATUS_CTRL_SENT		0x0004
#define BLK_STATUS_CTRL_RECEIVED	0x0008

#define BIT_BLK_STATUS_STAT_SENT	 0
#define BIT_BLK_STATUS_STAT_RECEIVED	 1
#define BIT_BLK_STATUS_CTRL_SENT	 2
#define BIT_BLK_STATUS_CTRL_RECEIVED	 3

#define BLK_MODE_NO_CLOCK		0x0001		/* Do not set clock from received frame	*/
#define BIT_BLK_MODE_NO_CLOCK		0

#endif

/****************************************************************************************************************
 *
 * Line disciplines
 *
 */
#define TTYDISC		0
#define MDBDISC		1
#define MBUSDISC	2
#define MUPPDISC	3
#define CCNETDISC	4
#define CCTALKDISC	5
#define BLOCKDISC	6
#define TTNDISC		7

/****************************************************************************************************************
 *
 * Protocols
 *
 */
#ifdef __CORE4_VISIBLE

#define CPDEFAULT	0
#define CPMDB		1
#define CPMBUS		2

#endif

/****************************************************************************************************************
 *
 * Predefined speeds
 *
 */
#define B0      0
#define B50     50
#define B75     75
#define B110    110
#define B134    134
#define B150    150
#define B200    200
#define B300    300
#define B600    600
#define B1200   1200
#define B1800   1800
#define B2400   2400
#define B4800   4800
#define B9600   9600
#define B19200  19200
#define B38400  38400
#define B57600  57600
#define B115200 115200
#define B230400 230400
#define B460800 460800
#define B921600 921600

/****************************************************************************************************************/
#endif
