#ifndef _SYS_SYSCALL_H_
#define _SYS_SYSCALL_H_

/****************************************************************************************************************/

#include <core/swi.h>

/****************************************************************************************************************/

#define __SWI2(x) #x
#define __SWI1(x) __SWI2(x)
#define __SWI0(x) __SWI1(x)

/****************************************************************************************************************/

#define _syscall0(type,name)											\
static inline type name(void) __attribute__((always_inline));							\
static inline type name(void) {											\
  register long __res_r0 __asm__("r0");										\
  long __res;                                                                   				\
  __asm__ __volatile__ ("swi " __SWI1(__swi_##name)								\
	: "=r" (__res_r0)											\
	:													\
	: "r1", "r2", "r3", "r12", "cc", "memory");								\
  __res = __res_r0;                                                             				\
  return (type) (__res);											\
}

/****************************************************************************************************************/

#define _syscall1(type,name,type1,arg1)										\
static inline type name(type1 arg1) __attribute__((always_inline));						\
static inline type name(type1 arg1) {										\
  register long __r0 __asm__("r0") = (long)arg1;								\
  register long __res_r0 __asm__("r0");										\
  long __res;                                                                   				\
  __asm__ __volatile__ ("swi " __SWI1(__swi_##name)								\
	: "=r" (__res_r0)											\
	: "0" (__r0)												\
	: "r1", "r2", "r3", "r12", "cc", "memory");								\
  __res = __res_r0;                                                             				\
  return (type) (__res);											\
}

/****************************************************************************************************************/

#define _syscall2(type,name,type1,arg1,type2,arg2)								\
static inline type name(type1 arg1,type2 arg2) __attribute__((always_inline));					\
static inline type name(type1 arg1,type2 arg2) {								\
  register long __r0 __asm__("r0") = (long)arg1;								\
  register long __r1 __asm__("r1") = (long)arg2;								\
  register long __res_r0 __asm__("r0");										\
  long __res;                                                                   				\
  __asm__ __volatile__ ("swi " __SWI1(__swi_##name)								\
	: "=r" (__res_r0), "=r" (__r1)										\
	: "0" (__r0), "1" (__r1)										\
	: "r2", "r3", "r12", "cc", "memory");									\
  __res = __res_r0;                                                             				\
  return (type) (__res);											\
}

/****************************************************************************************************************/

#define _syscall3(type,name,type1,arg1,type2,arg2,type3,arg3)							\
static inline type name(type1 arg1,type2 arg2,type3 arg3) __attribute__((always_inline));			\
static inline type name(type1 arg1,type2 arg2,type3 arg3) {							\
  register long __r0 __asm__("r0") = (long)arg1;								\
  register long __r1 __asm__("r1") = (long)arg2;								\
  register long __r2 __asm__("r2") = (long)arg3;								\
  register long __res_r0 __asm__("r0");										\
  long __res;                                                                   				\
  __asm__ __volatile__ ("swi " __SWI1(__swi_##name)								\
	: "=r" (__res_r0), "=r" (__r1), "=r" (__r2)								\
	: "0" (__r0), "1" (__r1), "2" (__r2)									\
	: "r3", "r12", "cc", "memory");										\
  __res = __res_r0;                                                             				\
  return (type) (__res);											\
}

/****************************************************************************************************************/

#define _syscall4(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4)					\
static inline type name(type1 arg1,type2 arg2,type3 arg3,type4 arg4) __attribute__((always_inline)); 		\
static inline type name(type1 arg1,type2 arg2,type3 arg3,type4 arg4) {						\
  register long __r0 __asm__("r0") = (long)arg1;								\
  register long __r1 __asm__("r1") = (long)arg2;								\
  register long __r2 __asm__("r2") = (long)arg3;								\
  register long __r3 __asm__("r3") = (long)arg4;								\
  register long __res_r0 __asm__("r0");										\
  long __res;                                                                   				\
  __asm__ __volatile__ ("swi " __SWI1(__swi_##name)								\
	: "=r" (__res_r0), "=r" (__r1), "=r" (__r2), "=r" (__r3)						\
	: "0" (__r0), "1" (__r1), "2" (__r2), "3" (__r3)							\
	: "r12", "cc", "memory");										\
  __res = __res_r0;                                                             				\
  return (type) (__res);											\
}

/****************************************************************************************************************/

#define _syscall5(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4,type5,arg5)				\
static inline type name(type1 arg1,type2 arg2,type3 arg3,type4 arg4, type5 arg5) __attribute__((always_inline)); \
static inline type name(type1 arg1,type2 arg2,type3 arg3,type4 arg4, type5 arg5) {				\
  register long __r0 __asm__("r0") = (long)arg1;								\
  register long __r1 __asm__("r1") = (long)arg2;								\
  register long __r2 __asm__("r2") = (long)arg3;								\
  register long __r3 __asm__("r3") = (long)arg4;								\
  register long __r4 __asm__("r4") = (long)arg5;								\
  register long __res_r0 __asm__("r0");										\
  long __res;                                                                   				\
  __asm__ __volatile__ ("swi " __SWI1(__swi_##name)								\
	: "=r" (__res_r0), "=r" (__r1), "=r" (__r2), "=r" (__r3)						\
	: "0" (__r0), "1" (__r1), "2" (__r2), "3" (__r3), "r" (__r4)						\
	: "r12", "cc", "memory");										\
  __res = __res_r0;                                                             				\
  return (type) (__res);											\
}

/****************************************************************************************************************/

#define _syscall6(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4,type5,arg5,type6,arg6)			\
static inline type name(type1 arg1,type2 arg2,type3 arg3,type4 arg4, type5 arg5, type6 arg6)			\
										__attribute__((always_inline)); \
static inline type name(type1 arg1,type2 arg2,type3 arg3,type4 arg4, type5 arg5, type6 arg6) {			\
  register long __r0 __asm__("r0") = (long)arg1;								\
  register long __r1 __asm__("r1") = (long)arg2;								\
  register long __r2 __asm__("r2") = (long)arg3;								\
  register long __r3 __asm__("r3") = (long)arg4;								\
  register long __r4 __asm__("r4") = (long)arg5;								\
  register long __r5 __asm__("r5") = (long)arg6;								\
  register long __res_r0 __asm__("r0");										\
  long __res;                                                                   				\
  __asm__ __volatile__ ("swi " __SWI1(__swi_##name)								\
	: "=r" (__res_r0), "=r" (__r1), "=r" (__r2), "=r" (__r3)						\
	: "0" (__r0), "1" (__r1), "2" (__r2), "3" (__r3), "r" (__r4), "r" (__r5)				\
	: "r12", "cc", "memory");										\
  __res = __res_r0;                                                             				\
  return (type) (__res);											\
}

/****************************************************************************************************************/

#define _syscall7(type,name,type1,arg1,type2,arg2,type3,arg3,type4,arg4,type5,arg5,type6,arg6,type7,arg7)	\
static inline type name(type1 arg1,type2 arg2,type3 arg3,type4 arg4, type5 arg5, type6 arg6, type7 arg7)	\
										__attribute__((always_inline)); \
static inline type name(type1 arg1,type2 arg2,type3 arg3,type4 arg4, type5 arg5, type6 arg6, type7 arg7) {	\
  register long __r0 __asm__("r0") = (long)arg1;								\
  register long __r1 __asm__("r1") = (long)arg2;								\
  register long __r2 __asm__("r2") = (long)arg3;								\
  register long __r3 __asm__("r3") = (long)arg4;								\
  register long __r4 __asm__("r4") = (long)arg5;								\
  register long __r5 __asm__("r5") = (long)arg6;								\
  register long __r6 __asm__("r6") = (long)arg7;								\
  register long __res_r0 __asm__("r0");										\
  long __res;                                                                   				\
  __asm__ __volatile__ ("swi " __SWI1(__swi_##name)								\
	: "=r" (__res_r0), "=r" (__r1), "=r" (__r2), "=r" (__r3)						\
	: "0" (__r0), "1" (__r1), "2" (__r2), "3" (__r3), "r" (__r4), "r" (__r5), "r" (__r6)			\
	: "r12", "cc", "memory");										\
  __res = __res_r0;                                                             				\
  return (type) (__res);											\
}

/****************************************************************************************************************/
#endif
