#ifndef _CORE_SWI_H_ /**************************************************************************** -*- assy -*- */
#define _CORE_SWI_H_

/****************************************************************************************************************
 *
 * Changed whenever the syscall ORDER changes. This will cause any binary that advertises a different API
 * version to abort early instead of wrecking havoc.
 *
 * Not changed when adding system calls to the end of the list, since then the API stays backwards compatible.
 *
 */
#define __CORE4_API_VERSION	1

/****************************************************************************************************************/

#define __swi_writek		0	/* Output text to debug console						*/
#define __swi_unused1		1 
#define __swi_lseek		2	/* Set file pointer							*/
#define __swi_yield		3	/* Task is bored							*/
#define __swi__exit		4	/* Exit and delete a task						*/
#define __swi_mmap		5	/* Map some memory region						*/
#define __swi__sysconf		6	/* Ask for certain system properties					*/
#define __swi_random		7	/* Get 32bits of randomness						*/
#define __swi_nop		8	/* Do nothing								*/
#define __swi_schedule		9	/* Try to run another task						*/

#define __swi_api_init		16	/* Tell kernel where the errno variable lives				*/
#define __swi_open		17	/* Open or create a file						*/
#define __swi_openat		18
#define __swi_close		19	/* Close a file descriptor						*/
#define __swi_read		20	/* Read from a file							*/
#define __swi_readv		21	/* Read several buffers from a file					*/
#define __swi_pread		22
#define __swi_write		23	/* Write into a file							*/
#define __swi_writev		24 	/* Write several buffers into a file					*/
#define __swi_pwrite		25 
#define __swi_getdents		26 	/* Get directory entries						*/
#define __swi_revoke		27 
#define __swi_truncate		28 	/* Truncate a file							*/
#define __swi_ftruncate		29 	/* Truncate a file by descriptor					*/
#define __swi_select		30
#define __swi_poll		31 	/* Poll for events on some open files					*/
#define __swi_epoll_create	32 
#define __swi_epoll_ctl		33 
#define __swi_epoll_wait	34 
#define __swi_stat		35 	/* Get file info							*/
#define __swi_lstat		36	/* Get file info, do not follow symlink					*/
#define __swi_fstat		37	/* Get file info by descriptor						*/
#define __swi_fstatat		38
#define __swi_utimes		39 	/* Update file access times						*/
#define __swi_futimes		40 	/* Update file access times						*/
#define __swi_futimesat		41 	/* Update file access times						*/
#define __swi_statfs		42 	/* Get filesystem info							*/
#define __swi_fstatfs		43 	/* Get filesystem info by descriptor					*/
#define __swi_dup		44 	/* Duplicate an open file descriptor					*/
#define __swi_dup2		45 	/* Duplicate an open file descriptor					*/
#define __swi__pipe		46 	/* Create a pipe							*/
#define __swi_ioctl		47 	/* Control on a device file						*/
#define __swi_access		48 	/* Check if file can be accessed					*/
#define __swi_faccessat		49 
#define __swi_rename		50 	/* Change name of a file						*/
#define __swi_renameat		51 
#define __swi_fcntl		52 	/* Control on a file descriptor						*/
#define __swi_mkdir		53 	/* Create a directory							*/
#define __swi_mkdirat		54 
#define __swi_mkfifo		55 	/* Dummy								*/
#define __swi_mknod		56 	/* Dummy								*/
#define __swi_rmdir		57 	/* Delete a directory							*/
#define __swi_link		58 	/* Make two filenames point to one file					*/
#define __swi_linkat		59 
#define __swi_unlink		60 	/* Remove directory entry						*/
#define __swi_unlinkat		61 
#define __swi_symlink		62 
#define __swi_symlinkat		63 
#define __swi_readlink		64 
#define __swi_readlinkat	65 
#define __swi_mount		66  	/* Put a file system into the tree					*/
#define __swi_umount2		67  	/* Remove a file system from the tree					*/
#define __swi_chdir		68  	/* Change into a new directory						*/
#define __swi_fchdir		69  	/* Change into a new directory						*/
#define __swi_getchdir		70 	/* Return current directory						*/
#define __swi_chroot		71 	/* Make the given directory our root					*/
#define __swi_chmod		72 	/* Change protection bits of a file					*/
#define __swi_fchmod		73 
#define __swi_fchmodat		74 
#define __swi_umask		75 	/* Set protection bits for current process				*/
#define __swi_clock_gettime	76 	/* Get value of a system clock						*/
#define __swi_clock_settime	77 	/* Set value of a system clock						*/
#define __swi_clock_getres	78 	/* Get resolution of a system clock					*/
#define __swi_times		79 	/* Get time used by current process					*/
#define __swi_vfork		80 	/* Fork off a new task, faster, less secure				*/
#define __swi_fork		81 	/* Fork off a new task							*/
#define __swi_clone		82  	/* Fork off a new task							*/
#define __swi_getrusage		83 	/* Get resource usage of a task						*/
#define __swi_wait4		84 	/* Wait for a specific child task to finish				*/
#define __swi_getpid		85 	/* Current process id							*/
#define __swi_getppid		86 	/* Parent process id							*/
#define __swi_madvise		87 	/* Dummy								*/
#define __swi_nice_p		88      /* Change task priority							*/
#define __swi_execve		89 	/* Exec, using a file name and environment				*/
#define __swi_sysctl		90 	/* A mess of unserted stuff, e.g. hardware reset, buzz, ...		*/
#define __swi_kill		91 	/* Send a signal to any task						*/
#define __swi_raise		92 	/* Send a signal to current task					*/
#define __swi_sigaction		93 	/* Set up callback to a signal						*/
#define __swi_sigprocmask	94 	/* Set up or get the signal disable mask				*/
#define __swi_sigpending	95 	/* Query which signals are pending					*/
#define __swi_sigsuspend	96 	/* Temporary change disable and go to sleep				*/
#define __swi_socket		97 	/* Create a new socket file descriptor					*/
#define __swi_bind		98 	/* Bind a socket to an address						*/
#define __swi_listen		99 	/* Listen for incoming connections					*/
#define __swi_accept		100	/* Accept an incoming connection					*/
#define __swi_connect		101	/* Do an outgoing connection						*/
#define __swi_shutdown		102	/* Shut down a socket							*/
#define __swi_setsockopt	103	/* Set options on a socket						*/
#define __swi_getsockopt	104	/* Get options on a socket						*/
#define __swi_getsockname	105	/* Get "name" of local end of socket					*/
#define __swi_getpeername	106	/* Get "name" of remote end of socket					*/
#define __swi_send		107	/* Send to network							*/
#define __swi_sendto		108	/* Send to network with address given					*/
#define __swi_sendmsg		109	/* Reserved								*/
#define __swi_recv		110	/* Receive from network							*/
#define __swi_recvfrom		111	/* Receive from network with address given				*/
#define __swi_recvmsg		112 	/* Reserved								*/
#define __swi_munmap		113 	/* Unmap some memory region						*/
#define __swi_mprotect		114	/* Change protection of a mapped region					*/
#define __swi_msync		115	/* Sync mapping with file						*/
#define __swi_mlock		116	/* Lock pages into memory						*/
#define __swi_munlock		117	/* Unlock pages from memory						*/
#define __swi_mlockall		118	/* Lock all pages of a process						*/
#define __swi_munlockall	119	/* Unlock all pages of a process					*/
#define __swi_gethostname	120	/* Get configured host name						*/
#define __swi_sethostname	121	/* Change host name							*/
#define __swi_uname		122	/* Get information about system						*/
#define __swi_kdump		123	/* Debug kernel data							*/
#define __swi_ualarm		124	/* Set timer for SIGALRM						*/
#define __swi_setpgid		125	/* Set process group ID							*/
#define __swi_getpgid		126	/* Get process group ID							*/
#define __swi_setsid		127	/* Start a new session							*/
#define __swi_setuid		128	/* Dummy								*/
#define __swi_seteuid		129	/* Dummy								*/
#define __swi_setreuid		130	/* Dummy								*/
#define __swi_getuid		131	/* Dummy								*/
#define __swi_geteuid		132	/* Dummy								*/
#define __swi_setgid		133	/* Dummy								*/
#define __swi_setegid		134	/* Dummy								*/
#define __swi_setregid		135	/* Dummy								*/
#define __swi_getgid		136	/* Dummy								*/
#define __swi_getegid		137	/* Dummy								*/
#define __swi_setgroups		138	/* Dummy								*/
#define __swi_getgroups		139	/* Dummy								*/
#define __swi_nanosleep		140	/* Sleep for some time							*/
#define __swi_c4sysinfo_old	141	/* Get info about hardware. Fixed buffer size.				*/
#define __swi_getrlimit		142	/* Dummy								*/
#define __swi_setrlimit		143	/* Dummy								*/
#define __swi__sync		144	/* Write back buffered data						*/
#define __swi_c4sysinfo		145	/* Get info about hardware. Buffer size passed as parameter.		*/
#define __swi_clock_adjtime	146	/* Fudge clock slowly							*/

/****************************************************************************************************************/

#define __swi_stringify(x) #x
#define __swi(x) __asm__ volatile ("swi " __swi_stringify(x)) /* Macro to call a swi from C			*/

/****************************************************************************************************************/

#endif

