#ifndef _CORE_SIGNAL_H_
#define _CORE_SIGNAL_H_

/****************************************************************************************************************/

#include <core/types.h>

#include <core/signr.h>

struct sigaction {
  void (*sa_handler)(int);
  sigset_t sa_mask;
  int sa_flags;
};

typedef void (*sighandler_t)(int);

/****************************************************************************************************************/

#define SIG_DFL ((sighandler_t)0)       // Default signal handler
#define SIG_IGN ((sighandler_t)1)       // Ignore the signal
#define SIG_ERR ((sighandler_t)-1)      // Error return

/****************************************************************************************************************/

#define _NSIG			((int)(sizeof(sigset_t) * 8))
#define NSIG		_NSIG

/****************************************************************************************************************/
#endif
