#ifndef C4TAGS_H
#define C4TAGS_H

/*****************************************************************************************************************
 *
 * General configuration branch
 *
 */
#define C4S_GENERAL		0xFFC40000		/* General section					*/
#define C4T_GEN_DEVELOPMENT_MODE	0x02C40001	/* Enable development mode				*/
#define C4T_GEN_RESTRICT_DISCOVERY	0x02C40002	/* Disable discovery write access w/o debug jumper	*/
#define C4T_GEN_TIMEZONE		0x03C40003	/* Timezone string					*/
#define C4T_GEN_CLOCK			0x11C40004	/* CPU Clock						*/
#define C4T_GEN_PASSWORD		0x19C40005	/* Application password					*/
#define C4T_GEN_DISPLAY_ORIENTATION	0x10C40006	/* Default framebuffer orientation (90° steps)		*/
#define C4T_GEN_SYSTEM_NAME		0x03C40007	/* Arbitrary system name				*/
#define C4T_GEN_DISPLAY_SIZE		0x22C40008	/* Default framebuffer size hint			*/
#define C4T_GEN_RESTRICT_DEBUG_CONSOLE	0x02C40009	/* Disable debug console access				*/

/*****************************************************************************************************************
 *
 * Networking configuration branch
 *
 */
#define C4S_NETWORK		0xFFC40100		/* Network section					*/

#define C4T_NET_MODE			0x10C40100	/* Network mode						*/
#define C4T_NET_IP			0x14C40101	/* IP Address						*/
#define C4T_NET_NETMASK			0x14C40102	/* Network mask						*/
#define C4T_NET_GW			0x14C40103	/* Default gateway					*/
#define C4T_NET_BOOT_IP			0x14C40104	/* Boot source host for TFTP				*/
#define C4T_NET_BOOT_PATH		0x03C40105	/* Boot source filename for TFTP			*/
#define C4T_NET_BOOT_PORT		0x11C40106	/* Boot port number for TFTP				*/
#define C4T_NET_SYSLOG_IP		0x14C40107	/* IP Address of syslog server				*/
#define C4T_NET_SYSLOG_PORT		0x11C40107	/* Destination port of syslog server			*/

#define C4T_NET_APPSERVER_IP		0x14C40108	/* Application server IP address			*/
#define C4T_NET_APPSERVER_PORT		0x11C40109	/* Application server port number			*/
#define C4T_NET_APPSERVER_PATH		0x03C4010A	/* Path on application server (for building an URL)	*/
#define C4T_NET_APPSERVER_SCHEME	0x03C4010B	/* URL scheme for application server			*/
#define C4T_NET_APPSERVER_URL		0x03C40108	/* Application server full URL				*/
#define C4T_NET_LISTEN_IP		0x14C4010C	/* IP address to listen at for incoming connections	*/
#define C4T_NET_LISTEN_PORT		0x11C4010D	/* Port number to listen at for incoming connections	*/
#define C4T_NET_ROOT_PATH		0x03C4010E	/* NFS path to root filesystem				*/
#define C4T_NET_DNS1			0x14C4010F	/* DNS Server 1						*/
#define C4T_NET_DNS2			0x14C40110	/* DNS Server 2						*/
#define C4T_NET_NTP			0x14C40111	/* IP Address of NTP time server			*/
#define C4T_NET_BUDDY_ADDRESS           0x14C40112	/* IP Address of buddy device				*/
#define C4T_NET_BUDDY_PORT              0x01C40112	/* Port number for connecting with buddy device		*/
#define C4T_NET_BUDDY_MODE              0x10C40112	/* Buddy connection mode: None, Client, Server		*/
#define C4T_NET_DIAG_IP			0x14C40113	/* IP Address of diagnostics server			*/
#define C4T_NET_DIAG_PORT		0x11C40113	/* Destination port of diagnostics server		*/

/*
 * Enumeration values for C4T_NET_MODE
 */
#define C4E_NET_MODE_DISABLED	0			/* Networking disabled					*/
#define C4E_NET_MODE_DHCP	1			/* Configure by DHCP					*/
#define C4E_NET_MODE_STATIC	2			/* Static configuration					*/

#define C4E_NET_MODE_DEFAULT	C4E_NET_MODE_DHCP

/*
 * Enumeration values for C4T_NET_BUDDY_MODE
 */
#define C4E_NET_BUDDY_MODE_DISABLED	0		/* Buddy connection not used				*/
#define C4E_NET_BUDDY_MODE_SERVER	1		/* This device listens for buddy connections		*/
#define C4E_NET_BUDDY_MODE_CLIENT	2		/* This device connects to its buddy device		*/

/*****************************************************************************************************************
 *
 * Serial port branch
 *
 */
#define C4S_SERIAL		0xFFC402FF		/* Serial ports sections				*/

#define C4S_SER_TTYS0		0xFFC40200		/* One section for each port				*/
#define C4S_SER_TTYS1		0xFFC40201
#define C4S_SER_TTYS2		0xFFC40202
#define C4S_SER_TTYS3		0xFFC40203
#define C4S_SER_TTYS4		0xFFC40204
#define C4S_SER_TTYS5		0xFFC40205
#define C4S_SER_TTYS6		0xFFC40206
#define C4S_SER_TTYS7		0xFFC40207
#define C4S_SER_TTYS8		0xFFC40208
#define C4S_SER_TTYS9		0xFFC40209
#define C4S_SER_TTYS10		0xFFC4020A
#define C4S_SER_TTYS11		0xFFC4020B
#define C4S_SER_TTYS12		0xFFC4020C
#define C4S_SER_TTYS13		0xFFC4020D
#define C4S_SER_TTYS14		0xFFC4020E
#define C4S_SER_TTYS15		0xFFC4020F
#define C4S_SER_TTYS16		0xFFC40210
#define C4S_SER_TTYS17		0xFFC40211
#define C4S_SER_TTYS18		0xFFC40212
#define C4S_SER_TTYS19		0xFFC40213
#define C4S_SER_TTYS20		0xFFC40214
#define C4S_SER_TTYS21		0xFFC40215
#define C4S_SER_TTYS22		0xFFC40216
#define C4S_SER_TTYS23		0xFFC40217
#define C4S_SER_TTYS24		0xFFC40218
#define C4S_SER_TTYS25		0xFFC40219
#define C4S_SER_TTYS26		0xFFC4021A
#define C4S_SER_TTYS27		0xFFC4021B
#define C4S_SER_TTYS28		0xFFC4021C
#define C4S_SER_TTYS29		0xFFC4021D
#define C4S_SER_TTYS30		0xFFC4021E
#define C4S_SER_TTYS31		0xFFC4021F

#define C4T_SER_SPEED		0x11C40200		/* Port speed						*/
#define C4T_SER_ADDRESS		0x11C40201		/* Network address					*/

/*****************************************************************************************************************
 *
 * Display configuration branch
 *
 */
#define C4S_DISPLAY		0xFFC403FF		/* Display section					*/

#define C4T_DISPLAY_TOUCH		0x00C40300	/* Touch calibration					*/
#define C4T_DISPLAY_TFP410_DESKEW	0x11C40301	/* TFP410 deskew initial value				*/

/*****************************************************************************************************************
 *
 * Remote GPIO pairing branch
 *
 */
#define C4S_GPIO_PAIRING	0xFFC40400

#define C4S_GPIO_PAIR0		0xFFC40400		/* One section for each pairing				*/
#define C4S_GPIO_PAIR1		0xFFC40401
#define C4S_GPIO_PAIR2		0xFFC40402
#define C4S_GPIO_PAIR3		0xFFC40403
#define C4S_GPIO_PAIR4		0xFFC40404
#define C4S_GPIO_PAIR5		0xFFC40405
#define C4S_GPIO_PAIR6		0xFFC40406
#define C4S_GPIO_PAIR7		0xFFC40407
#define C4S_GPIO_PAIR8		0xFFC40408
#define C4S_GPIO_PAIR9		0xFFC40409
#define C4S_GPIO_PAIR10		0xFFC4040A
#define C4S_GPIO_PAIR11		0xFFC4040B
#define C4S_GPIO_PAIR12		0xFFC4040C
#define C4S_GPIO_PAIR13		0xFFC4040D
#define C4S_GPIO_PAIR14		0xFFC4040E
#define C4S_GPIO_PAIR15		0xFFC4040F
#define C4S_GPIO_PAIR16		0xFFC40410
#define C4S_GPIO_PAIR17		0xFFC40411
#define C4S_GPIO_PAIR18		0xFFC40412
#define C4S_GPIO_PAIR19		0xFFC40413
#define C4S_GPIO_PAIR20		0xFFC40414
#define C4S_GPIO_PAIR21		0xFFC40415
#define C4S_GPIO_PAIR22		0xFFC40416
#define C4S_GPIO_PAIR23		0xFFC40417
#define C4S_GPIO_PAIR24		0xFFC40418
#define C4S_GPIO_PAIR25		0xFFC40419
#define C4S_GPIO_PAIR26		0xFFC4041A
#define C4S_GPIO_PAIR27		0xFFC4041B
#define C4S_GPIO_PAIR28		0xFFC4041C
#define C4S_GPIO_PAIR29		0xFFC4041D
#define C4S_GPIO_PAIR30		0xFFC4041E
#define C4S_GPIO_PAIR31		0xFFC4041F

#define C4T_GPIO_ID			0x11C40400    	/* Device ID (Mapped GPIO group)                        */
#define C4T_GPIO_KEY			0x00C40401     	/* Pairing key                                          */
#define C4T_GPIO_DEVICE			0x03C40402     	/* Name of device type                                  */
#define C4T_GPIO_VERSION		0x03C40403     	/* Version string                                       */
#define C4T_GPIO_INPUT_COUNT		0x11C40404    	/* Number of digital inputs                             */
#define C4T_GPIO_OUTPUT_COUNT           0x11C40405    	/* Number of digital outputs                            */

/****************************************************************************************************************/

#define C4S_SIGNAGE	        0xFFC40500

#define C4T_SIGNAGE_UNIT1_GEOMETRY      0x21C40501
#define C4T_SIGNAGE_UNIT2_GEOMETRY      0x21C40502
#define C4T_SIGNAGE_UNIT3_GEOMETRY      0x21C40503
#define C4T_SIGNAGE_UNIT4_GEOMETRY      0x21C40504

#define C4T_SIGNAGE_CURRENT_LIMIT       0x11C40510
#define C4T_SIGNAGE_TEMPERATURE_LIMIT   0x11C40511
#define C4T_SIGNAGE_COLOR_CORRECTION    0x11C40512
#define C4T_SIGNAGE_FAN_TEMPERATURE     0x11C40513
#define C4T_SIGNAGE_BRIGHTNESS_LIMIT    0x11C40514
#define C4T_SIGNAGE_LANE_COUNT          0x11C40515
#define C4T_SIGNAGE_TILE_LAYOUT         0x10C40516

#define C4E_SIGNAGE_TILE_LAYOUT_DEFAULT 0
#define C4E_SIGNAGE_TILE_LAYOUT_8x8     1
#define C4E_SIGNAGE_TILE_LAYOUT_16x16   2
#define C4E_SIGNAGE_TILE_LAYOUT_32x8    3
#define C4E_SIGNAGE_TILE_LAYOUT_32x16   4

/****************************************************************************************************************/
#endif
