#include <lua/mtd16.lh>

--****************************************************************************************************************

mtd16.lutTag = {
  --
  -- Some common data fields
  --
  StatusCode                = 0x1000, -- Integer
  StatusText                = 0x3000, -- String
  Language                  = 0x3024, -- String
  DataAge                   = 0x1025, -- Integer
  MaxWait                   = 0x1026, -- Integer
  Path                      = 0x3038, -- String
  Fields                    = 0x0035, -- Binary
  Inputs                    = 0x7040, -- BitArray
  Outputs                   = 0x7041, -- BitArray
  Left                      = 0x1042, -- Integer
  Right                     = 0x1043, -- Integer
  SignalShape               = 0x1044, -- Integer
  Frequency                 = 0x1045, -- Integer
  Duration                  = 0x1046, -- Integer
  Attack                    = 0x1047, -- Integer
  Decay                     = 0x1048, -- Integer
  Sustain                   = 0x1049, -- Integer
  Release                   = 0x104A, -- Integer

  ProtocolVersion           = 0x1100, -- Integer
  SoftwareOs                = 0x3100, -- String
  SoftwareName              = 0x3101, -- String
  SoftwareVersion           = 0x3102, -- String
  SoftwareFeatures          = 0x1102, -- Integer
  SoftwareDate              = 0x6102, -- DateTime
  HostDescription           = 0x3103, -- String
  Challenge                 = 0x0130, -- Binary
  Response                  = 0x0131, -- Binary

  Count                     = 0x1330, -- Integer
  Index                     = 0x1335, -- Integer
  Key                       = 0x3335, -- String
  Priority		    = 0x1337, -- Integer
  Item			    = 0x1338, -- Integer
  Pattern		    = 0x1339, -- Integer

  Data                      = 0x0500, -- Binary
  Text                      = 0x3500, -- String
  IndexedData               = 0xF500, -- Message
  Header                    = 0x0501, -- Binary
  FileDescriptor            = 0x1520, -- Integer
  FileOffset                = 0x1521, -- Integer
  FileLength                = 0x1522, -- Integer
  FileMode                  = 0x1523, -- Integer

  --
  -- Messages
  --
  Hello			    = 0xF000, -- Message
  Ping                      = 0xD001, -- Request
  Pong                      = 0xE001, -- Answer
}

--****************************************************************************************************************

mtd16.lutStatusCode = {
  Success                   = 0x0000,
  AccessDenied              = 0x0002,
  NotImplemented            = 0xFFFF,
}

--****************************************************************************************************************
