#ifndef _UNISTD_H_ /*********************************************************************************************/
#define _UNISTD_H_

#include <core/types.h>
#include <core/unistd.h>
#include <core/confname.h>
#include <core/syscall/unistd.h>
#include <sys/cdefs.h>

__BEGIN_DECLS

/****************************************************************************************************************/

#define STDIN_FILENO    0
#define STDOUT_FILENO   1
#define STDERR_FILENO   2

/****************************************************************************************************************/

char *getcwd(char *buf, size_t bufsize);

/****************************************************************************************************************/

int sleep(int secs);
int usleep(unsigned long usec);
int msleep(unsigned long msec);
int pause(void);
int alarm(int secs);

/****************************************************************************************************************/

int isatty(int fd);

int pipe(int filedes[2]);

/****************************************************************************************************************/

#ifdef __CORE4_VISIBLE
void printk(const char *fmt, ...);
#endif

/****************************************************************************************************************/

void _exit(int status) __attribute__((__noreturn__));

/****************************************************************************************************************/

int execl(const char *path, const char *arg, ...);
int execlp(const char *file, const char *arg, ...);
int execle(const char *path, const char *arg, ...);
int execv(const char *path, char *const argv[]);
int execvp(const char *file, char *const argv[]);

/****************************************************************************************************************/

char *ttyname(int fd);
int ttyname_r(int fd, char *buf, size_t buflen);

#ifdef __CORE4_VISIBLE
int ttydevname_r(int fd, char *buf, size_t buflen);
#endif

/****************************************************************************************************************/

long sysconf(int name);

/****************************************************************************************************************/

__attribute__((__always_inline__)) static inline int setpgrp(void)   { return setpgid(0, 0); }
__attribute__((__always_inline__)) static inline pid_t getpgrp(void) { return getpgid(0);    }

pid_t tcgetpgrp(int fd);
int tcsetpgrp(int fd, pid_t pgrp);

/****************************************************************************************************************/

ssize_t readn(int fd, void *buf, size_t count);
ssize_t writen(int fd, const void *buf, size_t count);

/****************************************************************************************************************/

int sync(void);
int fsync(int fd);
int fdatasync(int fd);

/****************************************************************************************************************/

#ifdef __BSD_VISIBLE
void *setmode(const char *p);
mode_t getmode(const void *bbox, mode_t omode);
#endif

/****************************************************************************************************************/

#ifndef NULL
#define NULL 0L
#endif

/****************************************************************************************************************/
__END_DECLS
#endif
