#ifndef _LIBINSTALL_INSTALL_H_
#define _LIBINSTALL_INSTALL_H_

#include <sys/types.h>
#include <sys/cdefs.h>

/*********************************************************************************************************/

#define INSTALL_ERROR_SUCCESS		0
#define INSTALL_ERROR_INVALID_DATA	1	// Not a firmware image
#define INSTALL_ERROR_MISMATCH		2	// Firmware not for this hardware
#define INSTALL_ERROR_INTERRUPTED	3	// Installation was interrupted
#define INSTALL_ERROR_FLASH_NOT_FOUND	4	// Flash memory not found
#define INSTALL_ERROR_OUT_OF_MEMORY	5	// Insufficient memory
#define INSTALL_ERROR_IMAGE_TOO_BIG	6	// Image does not fit into flash memory
#define INSTALL_ERROR_SYSCALL		7	// Error from system. See errno.
#define INSTALL_ERROR_BAD_MEMORY	8	// Not enough spare blocks
#define INSTALL_ERROR_FILE_ACCESS	9	// Cannot read firmware file

/*********************************************************************************************************/

__BEGIN_DECLS

typedef int progress_callback_t(void *data, unsigned int percent_complete, const char *info);

int install_firmware_file(const char *filename, progress_callback_t *cb, void *data);

int install_firmware(const void *firmware, size_t length, progress_callback_t *cb, void *data);

int install_wipe(progress_callback_t *cb, void *data);

const char *install_strerror(int error, char *buf, size_t bufsize);
const char *install_strerror_short(int error, char *buf, size_t bufsize);

struct install_progress_state;
struct install_progress_state *install_progress_open_display(void);
int install_progress_callback(void *data, unsigned int percent_complete, const char *info);
void install_progress_close(struct install_progress_state *ips);

__END_DECLS

/*********************************************************************************************************/
#endif
