#ifndef _CORE_TOUCH_H_
#define _CORE_TOUCH_H_

#include <core/types.h>

/****************************************************************************************************************
 *
 * API for the touch screen calibration non-volatile storage
 *
 * When TOUCHCAL_STATIC is _not_ set:
 *
 *    Xd = A * X + B * Y - C
 *    Yd = D * X + E * Y - F
 *
 * When TOUCHCAL_STATIC is set:
 *
 *    X spans the whole display and runs from C ... (A+C-1)
 *    Y spans the whole display and runs from F ... (E+F-1)
 *
 */
struct touch_calibration {
  int16 A;		// Xd = A * X + B * Y - C
  int16 B;
  int16 C;
  int16 D;		// Yd = D * X + E * Y - F
  int16 E;
  int16 F;
  int16 penthr;		// Pen pressure threshold
  int16 fingerthr;	// Finger pressure threshold
  uint16 flags;		// Flags
  uint16 panelid;	// Used to detect surprise change of display type
};

#define TOUCH_PROBE		   0x7450	// Only successful if touch screen exists
#define TOUCH_SETCALIB		   0x7453	// Saves calibration to permanent storage
#define TOUCH_GETCALIB		   0x7447	// Fills a passed "struct touch_calibration"
#define TOUCH_GETDEFAULTCALIB	   0x7444	// Fills a passed "struct touch_calibration" with defaults

#define TOUCHCAL_SWAPPED		1	// X/Y wiring is swapped
#define TOUCHCAL_XMIRROR		2	// X signal is mirrored
#define TOUCHCAL_YMIRROR		4	// Y signal is mirrored
#define TOUCHCAL_HARDWARE_AVERAGING	8	// Hardware provides for averaging control
#define TOUCHCAL_FILTERED		16	// Controller does all the filtering
#define TOUCHCAL_DRIFT_FREE		32	// Once calibrated it will never drift.
#define TOUCHCAL_AUTOMATIC		64	// Can automatically calibrate.
#define TOUCHCAL_CALIBRATED		128	// Reports already calibrated pixel-correct values
#define TOUCHCAL_NO_PRESSURE		256	// Does NOT support pressure values
#define TOUCHCAL_MULTITOUCH		512	// Can report multiple fingers

/****************************************************************************************************************/
#endif
