#ifndef _CORE_INPUT_H_
#define _CORE_INPUT_H_

#include <core/types.h>
#include <core/time.h>

/****************************************************************************************************************/
//
// Structure used for reporting an event
//
struct input_event {
  uint32 location;			// E.g. USB location ID of the event
  uint16 type;				// Type of event, see below
  uint16 flags;				// Event dependent flags
  uint32 code;				// Code of event, see below
  int32  value;				// Value of event
};

/****************************************************************************************************************/
//
// Event types
//
#define EV_SYN			0x00	// Sync
#define EV_KEY                  0x01	// Keys and buttons
#define EV_REL                  0x02	// Mouse movements
#define EV_ABS                  0x03	// Pen position
#define EV_MSC                  0x04	// Misc
#define EV_LED                  0x11	// Indicators
#define EV_SND                  0x12	// Buzzers
#define EV_PNP			0x13	// PnP information
#define EV_REP                  0x14	// Auto-repeat
#define EV_HID                  0x15	// Generic HID event
#define EV_SENSOR               0x20	// Indicators

/****************************************************************************************************************/
//
// Code values for buttons
//
#define BTN_MOUSE               0x110
#define BTN_LEFT                0x110
#define BTN_RIGHT               0x111
#define BTN_MIDDLE              0x112

#define BTN_DIGI		0x140

#define BTN_WHEEL		0x150

/****************************************************************************************************************/
//
// Code values for relative axes
//
#define REL_X			0x00
#define REL_Y			0x01
#define REL_WHEEL		0x10	// ..0x1F

/****************************************************************************************************************/
//
// Code values for absolute axes
//
#define ABS_X			0x00
#define ABS_Y			0x01
#define ABS_PRESSURE		0x18
#define ABS_FINGER		0x19

/****************************************************************************************************************/
//
// Code values for beeping
//
#define SND_CLICK		0x00
#define SND_BELL		0x01
#define SND_TONE		0x02
#define SND_TARGET		0x54
#define SND_BUZZ		0x5A

#define SND_TARGET_BUZZ		1
#define SND_TARGET_REFLECT	2

/****************************************************************************************************************/
//
// <value> field for keyboard scancodes
//
#define KEYVAL_DOWN		0
#define KEYVAL_UP		1
#define KEYVAL_REPEAT		2

/****************************************************************************************************************/
//
// Code values for sensors
//
#define SENSOR_ACCEL_X		0x00
#define SENSOR_ACCEL_Y		0x01
#define SENSOR_ACCEL_Z		0x02

#define SENSOR_LIGHT_VISIBLE	0x10
#define SENSOR_LIGHT_IR		0x11

#define SENSOR_TEMPERATURE	0x21

/****************************************************************************************************************/
#endif
