#ifndef _TOOL_NETMASK_
#define _TOOL_NETMASK_

#include <core/types.h>
#include <sys/cdefs.h>

__BEGIN_DECLS

// Takes a netmask and returns number of bits in it.
// e.g.: 255.255.255.0 -> 24  or  255.0.0.0 -> 8
// Returns -1 if value is not a valid netmask.

extern int netmask2bits(uint32 ip);

// Takes a bit count and returns a netmask for it.
// e.g.: 24 -> 255.255.255.0  or  28 -> 255.255.255.240
// Argument must be between 0..32,
// for any other value the result is undefined.

extern uint32 bits2netmask(int n);

__END_DECLS

#endif
