#ifndef _REGION_H_
#define _REGION_H_

/****************************************************************************************************************/

#include <sys/types.h>
#include <raster/geo.h>
#include <sys/cdefs.h>

/****************************************************************************************************************/

struct region {
  size_t count;			// Number of rects used
  size_t size;			// Number of rects that can be stored (Buffer size, 0 = non-malloc'ed buffer)
  struct rect boundary;		// Bounding rectangle
  struct rect *rects;		// Rectangles of the region
};

/****************************************************************************************************************/
//
// Initialize a fresh structure
//
__BEGIN_DECLS
void region_init(struct region *reg);

//
// Clear a region, freeing all memory
//
void region_clear(struct region *reg);

//
// Unite things into an existing region
//
int region_add_rectangle(struct region *reg, const struct rect *box);
int region_add_region(struct region *reg, const struct region *other);

//
// Remove things from an existing region
//
int region_remove_rectangle(struct region *reg, const struct rect *box);
int region_remove_region(struct region *reg, const struct region *other);

//
// Keep only things that are in both arguments
//
int region_intersect_rectangle(struct region *reg, const struct rect *box);
int region_intersect_region(struct region *reg, const struct region *other);

//
// Check what's inside
//
int region_contains_point(const struct region *reg, int x, int y);

#define RECTANGLE_OUT	0
#define RECTANGLE_PART	1
#define RECTANGLE_IN	2

int region_contains_rectangle(const struct region *reg, const struct rect *box);

//
// Low level code
//
int region_unite(struct region *dst, const struct region *reg1, const struct region *reg2);
int region_intersect(struct region *dst, const struct region *reg1, const struct region *reg2);
int region_subtract(struct region *dst, const struct region *reg1, const struct region *reg2);

void region_dump(const struct region *reg);
__END_DECLS

/****************************************************************************************************************/
#endif
