/**
 * \file version.h
 *
 * \brief Run-time version information
 *
 *  Copyright (C) 2006-2013, Brainspark B.V.
 *
 *  This file is part of PolarSSL (http://www.polarssl.org)
 *  Lead Maintainer: Paul Bakker <polarssl_maintainer at polarssl.org>
 *
 *  All rights reserved.
 *
 *  This code is re-licensed to Teratronik elektronische systeme gmbh (Licensee)
 *  by Offspark B.V. under a Commercial License for use in
 *  Teratronik v4 Controllers.
 *  
 *  Full terms of the Software License are stated in the relevant PolarSSL
 *  Commercial License Agreement (PL-TERATRONIK-130108).
 *  
 *  In short Licensee has a nonexclusive, perpetual, irrevocable worldwide
 *  license to use, make, have made, copy, modify and create derivative works
 *  of this Software in source and object code for purposes of developing and
 *  integrating the Software into the product(s) specified in the License.
 */
/*
 * This set of compile-time defines and run-time variables can be used to
 * determine the version number of the PolarSSL library used.
 */
#ifndef POLARSSL_VERSION_H
#define POLARSSL_VERSION_H

#include "config.h"

/**
 * The version number x.y.z is split into three parts.
 * Major, Minor, Patchlevel
 */
#define POLARSSL_VERSION_MAJOR  1
#define POLARSSL_VERSION_MINOR  3
#define POLARSSL_VERSION_PATCH  2

/**
 * The single version number has the following structure:
 *    MMNNPP00
 *    Major version | Minor version | Patch version
 */
#define POLARSSL_VERSION_NUMBER         0x01030200
#define POLARSSL_VERSION_STRING         "1.3.2"
#define POLARSSL_VERSION_STRING_FULL    "PolarSSL 1.3.2"

#if defined(POLARSSL_VERSION_C)

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Get the version number.
 *
 * \return          The constructed version number in the format
 *                  MMNNPP00 (Major, Minor, Patch).
 */
unsigned int version_get_number( void );

/**
 * Get the version string ("x.y.z").
 *
 * \param string    The string that will receive the value.
 *                  (Should be at least 9 bytes in size)
 */
void version_get_string( char *string );

/**
 * Get the full version string ("PolarSSL x.y.z").
 *
 * \param string    The string that will receive the value.
 *                  (Should be at least 18 bytes in size)
 */
void version_get_string_full( char *string );

#ifdef __cplusplus
}
#endif

#endif /* POLARSSL_VERSION_C */

#endif /* version.h */
