/**
 * \file pk.h
 *
 * \brief Public Key abstraction layer: wrapper functions
 *
 *  Copyright (C) 2006-2013, Brainspark B.V.
 *
 *  This file is part of PolarSSL (http://www.polarssl.org)
 *  Lead Maintainer: Paul Bakker <polarssl_maintainer at polarssl.org>
 *
 *  All rights reserved.
 *
 *  This code is re-licensed to Teratronik elektronische systeme gmbh (Licensee)
 *  by Offspark B.V. under a Commercial License for use in
 *  Teratronik v4 Controllers.
 *  
 *  Full terms of the Software License are stated in the relevant PolarSSL
 *  Commercial License Agreement (PL-TERATRONIK-130108).
 *  
 *  In short Licensee has a nonexclusive, perpetual, irrevocable worldwide
 *  license to use, make, have made, copy, modify and create derivative works
 *  of this Software in source and object code for purposes of developing and
 *  integrating the Software into the product(s) specified in the License.
 */

#ifndef POLARSSL_PK_WRAP_H
#define POLARSSL_PK_WRAP_H

#include "config.h"

#include "pk.h"

/* Container for RSA-alt */
typedef struct
{
    void *key;
    pk_rsa_alt_decrypt_func decrypt_func;
    pk_rsa_alt_sign_func sign_func;
    pk_rsa_alt_key_len_func key_len_func;
} rsa_alt_context;

#if defined(POLARSSL_RSA_C)
extern const pk_info_t rsa_info;
#endif

#if defined(POLARSSL_ECP_C)
extern const pk_info_t eckey_info;
extern const pk_info_t eckeydh_info;
#endif

#if defined(POLARSSL_ECDSA_C)
extern const pk_info_t ecdsa_info;
#endif

extern const pk_info_t rsa_alt_info;

#endif /* POLARSSL_PK_WRAP_H */
