/**
 * \file certs.h
 *
 * \brief Sample certificates and DHM parameters for testing
 *
 *  Copyright (C) 2006-2013, Brainspark B.V.
 *
 *  This file is part of PolarSSL (http://www.polarssl.org)
 *  Lead Maintainer: Paul Bakker <polarssl_maintainer at polarssl.org>
 *
 *  All rights reserved.
 *
 *  This code is re-licensed to Teratronik elektronische systeme gmbh (Licensee)
 *  by Offspark B.V. under a Commercial License for use in
 *  Teratronik v4 Controllers.
 *  
 *  Full terms of the Software License are stated in the relevant PolarSSL
 *  Commercial License Agreement (PL-TERATRONIK-130108).
 *  
 *  In short Licensee has a nonexclusive, perpetual, irrevocable worldwide
 *  license to use, make, have made, copy, modify and create derivative works
 *  of this Software in source and object code for purposes of developing and
 *  integrating the Software into the product(s) specified in the License.
 */
#ifndef POLARSSL_CERTS_H
#define POLARSSL_CERTS_H

#ifdef __cplusplus
extern "C" {
#endif

/* Concatenation of all available CA certificates */
extern const char test_ca_list[];

/*
 * Convenience for users who just want a certificate:
 * RSA by default, or ECDSA if RSA i not available
 */
extern const char *test_ca_crt;
extern const char *test_ca_key;
extern const char *test_ca_pwd;
extern const char *test_srv_crt;
extern const char *test_srv_key;
extern const char *test_cli_crt;
extern const char *test_cli_key;

#if defined(POLARSSL_ECDSA_C)
extern const char test_ca_crt_ec[];
extern const char test_ca_key_ec[];
extern const char test_ca_pwd_ec[];
extern const char test_srv_crt_ec[];
extern const char test_srv_key_ec[];
extern const char test_cli_crt_ec[];
extern const char test_cli_key_ec[];
#endif

#if defined(POLARSSL_RSA_C)
extern const char test_ca_crt_rsa[];
extern const char test_ca_key_rsa[];
extern const char test_ca_pwd_rsa[];
extern const char test_srv_crt_rsa[];
extern const char test_srv_key_rsa[];
extern const char test_cli_crt_rsa[];
extern const char test_cli_key_rsa[];
#endif

#if defined(POLARSSL_DHM_C)
extern const char test_dhm_params[];
#endif

#ifdef __cplusplus
}
#endif

#endif /* certs.h */
