#ifndef POLARSSL_AES_ALT_H
#define POLARSSL_AES_ALT_H

#include <cipher/aes.h>

typedef struct aes aes_context;

int aes_setkey_enc(aes_context *ctx, const unsigned char *key, unsigned int keysize);

int aes_setkey_dec(aes_context *ctx, const unsigned char *key, unsigned int keysize);

int aes_crypt_ecb(aes_context *ctx,
		  int mode,
		  const unsigned char input[16],
		  unsigned char output[16]);

int aes_crypt_cbc(aes_context *ctx,
		  int mode,
		  size_t length,
		  unsigned char iv[16],
		  const unsigned char *input,
		  unsigned char *output);

int aes_crypt_cfb128(aes_context *ctx,
		     int mode,
		     size_t length,
		     size_t *iv_off,
		     unsigned char iv[16],
		     const unsigned char *input,
		     unsigned char *output);

int aes_crypt_ctr(aes_context *ctx,
		  size_t length,
		  size_t *nc_off,
		  unsigned char nonce_counter[16],
		  unsigned char stream_block[16],
		  const unsigned char *input,
		  unsigned char *output);

#endif
