#ifndef _LIBKEYBOARD_SCANCODES_H_ /**** Used by LUA *************************************************************/
#define _LIBKEYBOARD_SCANCODES_H_

/****************************************************************************************************************/
//
// Place the scancode into the USB keyboard code page
//
#define SCANCODE(x) (0x70000 | (x))

/****************************************************************************************************************/
//
// Scancodes
//
// These are the scancodes used by USB keyboards in codepage 7 (Keyboard/Keypad)
// Naming convention talks about english, USA.
//
#define KEY_A			0x04
#define KEY_B 			0x05
#define KEY_C			0x06
#define KEY_D 			0x07
#define KEY_E 			0x08
#define KEY_F 			0x09
#define KEY_G 			0x0A
#define KEY_H 			0x0B
#define KEY_I 			0x0C
#define KEY_J 			0x0D
#define KEY_K 			0x0E
#define KEY_L 			0x0F
#define KEY_M			0x10
#define KEY_N 			0x11
#define KEY_O			0x12
#define KEY_P			0x13
#define KEY_Q			0x14
#define KEY_R 			0x15
#define KEY_S			0x16
#define KEY_T 			0x17
#define KEY_U 			0x18
#define KEY_V 			0x19
#define KEY_W			0x1A
#define KEY_X			0x1B
#define KEY_Y			0x1C
#define KEY_Z			0x1D
#define KEY_1			0x1E
#define KEY_2			0x1F
#define KEY_3			0x20
#define KEY_4			0x21
#define KEY_5			0x22
#define KEY_6			0x23
#define KEY_7			0x24
#define KEY_8			0x25
#define KEY_9			0x26
#define KEY_0			0x27
#define KEY_RETURN		0x28
#define KEY_ESCAPE 		0x29
#define KEY_BACKSPACE		0x2A
#define KEY_TAB			0x2B
#define KEY_SPACE 		0x2C
#define KEY_MINUS		0x2D
#define KEY_EQUAL		0x2E
#define KEY_BRACKET_LEFT	0x2F
#define KEY_BRACKET_RIGHT	0x30
#define KEY_BACKSLASH 		0x31
#define KEY_NON_US_NUMBER_SIGN	0x32
#define KEY_SEMICOLON		0x33
#define KEY_TICK		0x34
#define KEY_APOSTROPHE		0x35
#define KEY_COMMA		0x36
#define KEY_PERIOD		0x37
#define KEY_SLASH		0x38
#define KEY_CAPS_LOCK		0x39
#define KEY_F1 			0x3A
#define KEY_F2 			0x3B
#define KEY_F3 			0x3C
#define KEY_F4 			0x3D
#define KEY_F5 			0x3E
#define KEY_F6 			0x3F
#define KEY_F7 			0x40
#define KEY_F8 			0x41
#define KEY_F9 			0x42
#define KEY_F10 		0x43
#define KEY_F11 		0x44
#define KEY_F12 		0x45
#define KEY_PRINT_SCREEN	0x46
#define KEY_SCROLL_LOCK		0x47
#define KEY_PAUSE		0x48
#define KEY_INSERT		0x49
#define KEY_HOME		0x4A
#define KEY_PAGE_UP		0x4B
#define KEY_DELETE		0x4C
#define KEY_END			0x4D
#define KEY_PAGE_DOWN		0x4E
#define KEY_RIGHT		0x4F
#define KEY_LEFT		0x50
#define KEY_DOWN		0x51
#define KEY_UP			0x52

#define KEY_KP_NUM_LOCK		0x53
#define KEY_KP_SLASH		0x54
#define KEY_KP_ASTERISK		0x55
#define KEY_KP_MINUS		0x56
#define KEY_KP_PLUS		0x57
#define KEY_KP_ENTER		0x58
#define KEY_KP_1		0x59
#define KEY_KP_2		0x5A
#define KEY_KP_3		0x5B
#define KEY_KP_4		0x5C
#define KEY_KP_5		0x5D
#define KEY_KP_6		0x5E
#define KEY_KP_7		0x5F
#define KEY_KP_8		0x60
#define KEY_KP_9		0x61
#define KEY_KP_0		0x62
#define KEY_KP_PERIOD		0x63

#define KEY_NON_US_BACKSLASH	0x64
#define KEY_APPLICATION		0x65
#define KEY_POWER		0x66
#define KEY_KP_EQUAL		0x67
#define KEY_F13 		0x68
#define KEY_F14 		0x69
#define KEY_F15 		0x6A
#define KEY_F16 		0x6B
#define KEY_F17 		0x6C
#define KEY_F18 		0x6D
#define KEY_F19 		0x6E
#define KEY_F20 		0x6F
#define KEY_F21 		0x70
#define KEY_F22 		0x71
#define KEY_F23 		0x72
#define KEY_F24 		0x73
#define KEY_EXECUTE 		0x74
#define KEY_HELP		0x75
#define KEY_MENU		0x76
#define KEY_SELECT		0x77
#define KEY_STOP		0x78
#define KEY_AGAIN		0x79
#define KEY_UNDO		0x7A
#define KEY_CUT			0x7B
#define KEY_COPY		0x7C
#define KEY_PASTE		0x7D
#define KEY_FIND		0x7E
#define KEY_MUTE		0x7F
#define KEY_VOLUME_UP 		0x80
#define KEY_VOLUME_DOWN		0x81
#define KEY_LOCKING_CAPS_LOCK	0x82
#define KEY_LOCKING_NUM_LOCK	0x83
#define KEY_LOCKING_SCROLL_LOCK	0x84
#define KEY_KP_COMMA		0x85
#define KEY_KP_EQUAL_SIGN	0x86
#define KEY_INTERNATIONAL_1  	0x87
#define KEY_INTERNATIONAL_2	0x88
#define KEY_INTERNATIONAL_3	0x89
#define KEY_INTERNATIONAL_4	0x8A
#define KEY_INTERNATIONAL_5	0x8B
#define KEY_INTERNATIONAL_6	0x8C
#define KEY_INTERNATIONAL_7	0x8D
#define KEY_INTERNATIONAL_8	0x8E
#define KEY_INTERNATIONAL_9	0x8F
#define KEY_LANG1		0x90
#define KEY_LANG2		0x91
#define KEY_LANG3		0x92
#define KEY_LANG4		0x93
#define KEY_LANG5		0x94
#define KEY_LANG6		0x95
#define KEY_LANG7		0x96
#define KEY_LANG8		0x97
#define KEY_LANG9		0x98
#define KEY_ALTERNATE_ERASE	0x99
#define KEY_SYSREQ		0x9A
#define KEY_CANCEL 		0x9B
#define KEY_CLEAR 		0x9C
#define KEY_PRIOR 		0x9D
#define KEY_RETURN2 		0x9E // ???
#define KEY_SEPARATOR 		0x9F
#define KEY_OUT			0xA0
#define KEY_OPER		0xA1
#define KEY_CLEAR_AGAIN		0xA2
#define KEY_CRSEL_PROPS		0xA3
#define KEY_EXSEL 		0xA4

#define KEY_KP_00		0xB0
#define KEY_KP_000		0xB1
					  
#define KEY_LEFT_CONTROL	0xE0
#define KEY_LEFT_SHIFT 		0xE1
#define KEY_LEFT_ALT 		0xE2
#define KEY_LEFT_GUI		0xE3
#define KEY_RIGHT_CONTROL	0xE4
#define KEY_RIGHT_SHIFT 	0xE5
#define KEY_RIGHT_ALT 		0xE6
#define KEY_RIGHT_GUI		0xE7

/****************************************************************************************************************/
//
// Modifiers
//
#define MOD_LEFT_CONTROL	1		// Modifier keys that are held
#define MOD_LEFT_SHIFT		2
#define MOD_LEFT_ALT		4
#define MOD_LEFT_META		8
#define MOD_RIGHT_CONTROL	16
#define MOD_RIGHT_SHIFT		32
#define MOD_RIGHT_ALT		64
#define MOD_RIGHT_META		128

#define MOD_SCROLL		2048		// Scroll lock currently engaged.
#define MOD_NUM			4096		// Num lock currently engaged.
#define MOD_CAPS		8192		// Caps lock currently engaged.
#define MOD_BREAK		16384		// The key has been released.
#define MOD_REPEAT		32768		// This is a repetition of the last key event.

/****************************************************************************************************************/
//
// Keyboard LEDs
//
#define LED_NUM			1		// State of keyboard LEDs
#define LED_CAPS		2
#define LED_SCROLL		4
#define LED_COMPOSE		8
#define LED_KANA		16
#define LED_AUX5		32
#define LED_AUX6		64
#define LED_AUX7		128

/****************************************************************************************************************/
//
// Keyboard Country Codes
//
#define KBD_COUNTRY_NOT_SUPPORTED	0
#define KBD_COUNTRY_ARABIC		1
#define KBD_COUNTRY_BELGIAN		2
#define KBD_COUNTRY_CANADIAN_BILINGUAL	3
#define KBD_COUNTRY_CANADIAN_FRENCH	4
#define KBD_COUNTRY_CZECH_REPUBLIC	5
#define KBD_COUNTRY_DANISH		6
#define KBD_COUNTRY_FINNISH		7
#define KBD_COUNTRY_FRENCH		8
#define KBD_COUNTRY_GERMAN		9
#define KBD_COUNTRY_GREEK		10
#define KBD_COUNTRY_HEBREW		11
#define KBD_COUNTRY_HUNGARY		12
#define KBD_COUNTRY_INTERNATIONAL	13
#define KBD_COUNTRY_ITALIAN		14
#define KBD_COUNTRY_JAPAN_KATAKANA	15
#define KBD_COUNTRY_KOREAN		16
#define KBD_COUNTRY_LATIN_AMERICAN	17
#define KBD_COUNTRY_NETHERLANDS		18
#define KBD_COUNTRY_NORWEGIAN		19
#define KBD_COUNTRY_PERSIAN_FARSI	20
#define KBD_COUNTRY_POLAND		21
#define KBD_COUNTRY_PORTUGUESE		22
#define KBD_COUNTRY_RUSSIA		23
#define KBD_COUNTRY_SLOVAKIA		24
#define KBD_COUNTRY_SPANISH		25
#define KBD_COUNTRY_SWEDISH		26
#define KBD_COUNTRY_SWISS_FRENCH	27
#define KBD_COUNTRY_SWISS_GERMAN	28
#define KBD_COUNTRY_SWITZERLAND		29
#define KBD_COUNTRY_TAIWAN		30
#define KBD_COUNTRY_TURKISH_Q		31
#define KBD_COUNTRY_UK			32
#define KBD_COUNTRY_US			33
#define KBD_COUNTRY_YUGOSLAVIA		34
#define KBD_COUNTRY_TURKISH_F		35

/****************************************************************************************************************/
#endif
