#ifndef	_CORE_SYSINFO_H_
#define	_CORE_SYSINFO_H_

/****************************************************************************************************************/

#define SYS_NMLN 65		/* Also in core/sysinfo.h */

/****************************************************************************************************************/

struct core4sysinfo {
  uint64 ssn;				// Dallas one-wire format compatible silicon serial number

  struct {
    uint32 Data1;
    uint16 Data2;
    uint16 Data3;
    uint8 Data4[8];
  } guid;				// 16-byte universal unique identifier

  time_t timestamp;			// Timestamp when sysid was generated

  char cpu_manufacturer[SYS_NMLN];	// Maker and model of CPU
  char cpu_model[SYS_NMLN];

  char board_manufacturer[SYS_NMLN];	// Maker and model of board
  char board_model[SYS_NMLN];
  char board_revision[SYS_NMLN];

  uint32 cpu_id;			// Numeric CPU and board IDs
  uint32 cpu_rev;
  uint32 board_id;
  uint32 board_rev;

  uint32 nand_last_known_good;		// ID of last known good firmware in NAND.
};

/****************************************************************************************************************/
#endif
