#ifndef _CORE_PCM_H_
#define _CORE_PCM_H_

#include <core/types.h>

/****************************************************************************************************************/

#define AFMT_QUERY	 0x00

#define AFMT_U8		 0x08
#define AFMT_S8		 0x40

#define AFMT_U16_LE	 0x80
#define AFMT_S16_LE	 0x10

#define AFMT_S16_NE	AFMT_S16_LE
#define AFMT_U16_NE	AFMT_U16_LE

/****************************************************************************************************************/

#define SNDCTL_DSP_SETFMT		0x5001
#define SNDCTL_DSP_SPEED		0x5002
#define SNDCTL_DSP_CHANNELS		0x5003

#define SNDCTL_DSP_SETPLAYVOL		0x5004
#define SNDCTL_DSP_GETPLAYVOL		0x5084

#define SNDCTL_DSP_SETRECVOL		0x5005
#define SNDCTL_DSP_GETRECVOL		0x5085

#define SNDCTL_DSP_SETRECSRC		0x5006
#define SNDCTL_DSP_GETRECSRC		0x5086
#define SNDCTL_DSP_GETRECSRC_NAMES	0x5087

#define SNDCTL_DSP_HALT_INPUT		0x5008
#define SNDCTL_DSP_HALT_OUTPUT		0x5009
#define SNDCTL_DSP_HALT			0x500A
#define SNDCTL_DSP_SYNC			0x500B

#define SNDCTL_MIX_DESCRIPTION		0x4D00
#define SNDCTL_MIX_ENUMINFO		0x4D01
#define SNDCTL_MIX_EXTINFO		0x4D02
#define SNDCTL_MIX_NREXT		0x4D03
#define SNDCTL_MIX_NRMIX		0x4D04
#define SNDCTL_MIX_READ			0x4D05
#define SNDCTL_MIX_WRITE		0x4D06

/****************************************************************************************************************/

#define OSS_ID_SIZE	16

typedef char oss_id_t[OSS_ID_SIZE];

/****************************************************************************************************************/

#define OSS_ENUM_MAXVALUE	255

typedef struct oss_mixer_enuminfo {
  int dev;
  int ctrl;
  int nvalues;
  int version;
  short strindex[OSS_ENUM_MAXVALUE];
  char strings[3000];
} oss_mixer_enuminfo;

/****************************************************************************************************************/

typedef struct oss_mixer_value {
  int dev;
  int ctrl;
  int value;
  int flags;
  unsigned int timestamp;
  int filler[8];
} oss_mixer_value;

/****************************************************************************************************************/

typedef struct oss_mixext {
  int dev;
  int ctrl;
  int type;
  int maxvalue;
  int minvalue;
  int flags;
  oss_id_t id;
  int parent;
  int dummy;
  unsigned int timestamp;
  char data[64];
  unsigned char enum_present[32];
  int control_no;
  unsigned int desc;
  char extname[32];
  int update_counter;
  int rgbcolor;
  int filler[6];
} oss_mixext;

/* oss_mixext.type */
#define MIXT_DEVROOT		 0
#define MIXT_GROUP		 1
#define MIXT_ONOFF		 2
#define MIXT_ENUM		 3
#define MIXT_MONOSLIDER		 4
#define MIXT_STEREOSLIDER	 5
#define MIXT_MESSAGE		 6
#define MIXT_MONOVU		 7
#define MIXT_STEREOVU		 8
#define MIXT_MONOPEAK		 9
#define MIXT_STEREOPEAK		10
#define MIXT_RADIOGROUP		11
#define MIXT_MARKER		12
#define MIXT_VALUE		13
#define MIXT_HEXVALUE		14
#define MIXT_MONODB		15
#define MIXT_STEREODB		16
#define MIXT_SLIDER		17
#define MIXT_3D			18
#define MIXT_MONOSLIDER16	19
#define MIXT_STEREOSLIDER16	20
#define MIXT_MUTE		21
#define MIXT_ENUM_MULTI		22

// oss_mixext.flags */
#define MIXF_READABLE	0x00000001
#define MIXF_WRITEABLE	0x00000002
#define MIXF_POLL	0x00000004
#define MIXF_HZ		0x00000008
#define MIXF_STRING	0x00000010
#define MIXF_DYNAMIC	0x00000010
#define MIXF_OKFAIL	0x00000020
#define MIXF_FLAT	0x00000040
#define MIXF_LEGACY	0x00000080
#define MIXF_CENTIBEL	0x00000100
#define MIXF_DECIBEL	0x00000200
#define MIXF_MAINVOL	0x00000400
#define MIXF_PCMVOL	0x00000800
#define MIXF_RECVOL	0x00001000
#define MIXF_MONVOL	0x00002000
#define MIXF_WIDE	0x00004000
#define MIXF_DESCR	0x00008000
#define MIXF_DISABLED	0x00010000

/****************************************************************************************************************/
#endif
