#ifndef _CORE_FCNTLBITS_H_ /**** USED BY LUA ********************************************************************/
#define _CORE_FCNTLBITS_H_

#define O_RDONLY		0x00
#define O_WRONLY		0x01
#define O_RDWR			0x02
#define	O_ACCMODE		0x03
#define O_CREAT			0x40
#define O_EXCL			0x80
#define O_NOCTTY	       0x100
#define O_TRUNC		       0x200
#define O_APPEND	       0x400
#define O_NONBLOCK	       0x800
#define O_NDELAY	  O_NONBLOCK
#define O_SYNC		      0x1000
#define	O_DSYNC		      O_SYNC
#define	O_RSYNC		      O_SYNC
#define O_DIRECT	      0x4000	/* direct disk access hint					*/
#define O_LARGEFILE	      0x8000
#define O_DIRECTORY	     0x10000	/* must be a directory						*/
#define O_NOFOLLOW	     0x20000	/* don't follow links						*/
#define O_CLOEXEC	     0x80000	/* Close this file on calling execve()				*/

#define O_SILENT	  0x00800000	/* Device must not change state on open	(Core4 extension)	*/

#define O_APPROVED (O_APPEND | O_DIRECT | O_NONBLOCK) /* Changeable with fcntl	*/

#define AT_FDCWD		-100
#define AT_SYMLINK_NOFOLLOW	0x100
#define AT_REMOVEDIR		0x200
#define AT_SYMLINK_FOLLOW	0x400

#define	FAPPEND		O_APPEND
#define	FASYNC		O_ASYNC
#define	FFSYNC		O_SYNC
#define	FNONBLOCK	O_NONBLOCK
#define	FNDELAY		O_NONBLOCK

#define	F_DUPFD		0		/* duplicate file descriptor		*/
#define	F_GETFD		1		/* get file descriptor flags		*/
#define	F_SETFD		2		/* set file descriptor flags		*/
#define	F_GETFL		3		/* get file status flags		*/
#define	F_SETFL		4		/* set file status flags		*/
#define	F_GETOWN	5		/* get SIGIO/SIGURG proc/pgrp		*/
#define F_SETOWN	6		/* set SIGIO/SIGURG proc/pgrp		*/
#define	F_GETLK		7		/* get record locking information	*/
#define	F_SETLK		8		/* set record locking information	*/
#define	F_SETLKW	9		/* F_SETLK; wait if blocked		*/

#define F_DUPFD_CLOEXEC 1030		/* F_DUPFD, also set FD_CLOEXEC		*/

#define	FD_CLOEXEC	1		/* close-on-exec flag			*/

/* record locking flags (F_GETLK, F_SETLK, F_SETLKW) */
#define F_RDLCK		1		/* shared or read lock			*/
#define F_UNLCK		2		/* unlock				*/
#define F_WRLCK		3		/* exclusive or write lock		*/

#endif
