#ifndef _CORE_BLOCKBITS_H_ /**** USED BY LUA ********************************************************************/
#define _CORE_BLOCKBITS_H_

/****************************************************************************************************************
 *
 * Block device flags
 *
 */
#define BLKF_ONLINE		1		/* Media present						*/
#define BLKF_READONLY		2		/* Device is read-only						*/
#define BLKF_BLOCK_ERASE	4		/* Needs block erase before rewrite				*/
#define BLKF_BAD_BLOCKS		8		/* Device might have bad blocks (e.g. a NAND flash)		*/
#define BLKF_SLAVE		16		/* Is a slave device (e.g. a partition)				*/
#define BLKF_JOURNALABLE	32		/* Sector writing does not affect other sectors			*/
#define BLKF_REMOVABLE		64		/* Contains removable media					*/

/****************************************************************************************************************/
//
// Used by read/write commands
//
#define BLOCKREQ_INTERLEAVED	1		// Data and OOB are interleaved in br_data buffer
#define BLOCKREQ_ECC		2		// Kernel should compute or verify ECC code
#define BLOCKREQ_CLEANMARKER	4		// [TODO] On erase: Write a cleanmarker
#define BLOCKREQ_LOCKED		8		// On write: Mark sectors locked, so formatting will not erase it

/****************************************************************************************************************/

#define IOCTL_BLOCK_ERASE		0x4245		// Erase a row of sectors
#define IOCTL_BLOCK_GETGEO		0x4247		// Retrieve the device geometry
#define IOCTL_BLOCK_READOOB		0x424F		// Read OOB data only
#define IOCTL_BLOCK_WRITE		0x4257		// Write sector + oob data
#define IOCTL_BLOCK_READ		0x4252		// Read sector and/or oob data
#define IOCTL_BLOCK_SYNC		0x4253		// Flush data to device
#define IOCTL_BLOCK_DISCARD		0x4244		// Discard cached data
#define IOCTL_BLOCK_FORMAT		0x4246		// Format a block device
#define IOCTL_BLOCK_GETBADBLOCKS	0x4242		// Query the bad block bitmap

/****************************************************************************************************************/
#endif
