#ifndef _CORE_BLOCK_H_
#define _CORE_BLOCK_H_

#include <core/types.h>
#include <core/blockbits.h>
#include <core/fstypes.h>

/****************************************************************************************************************/
//
// Used by IOCTL_BLOCK_GETGEO
//
struct blk_geometry {
  unsigned int bg_flags;			// Flags
  size_t bg_sectors;				// Total number of sectors
  size_t bg_sector_size;			// Size of a single sector
  size_t bg_oob_size;				// Size of additional out-of-band data per sector
  size_t bg_erase_sectors;			// Number of sectors that make up an erase block (may be 0)
  unsigned int bg_spare[11];
};

/****************************************************************************************************************/
//
// Used by IOCTL_BLOCK_GETBADBLOCKS
//
struct blk_bad_block_map {
  uint32 *bbm_map;				// Buffer which receives the bad block bitmap
  size_t bbm_size;				// Size of buffer in bytes
  unsigned int bbm_spare[14];
};

/****************************************************************************************************************/
//
// Used by read/write commands
//
struct blk_req {
  size_t br_sector;
  size_t br_count;
  void *br_data;
  void *br_oob;
  unsigned int br_flags;
  unsigned int br_spare[11];
};

/****************************************************************************************************************/
//
// Used by IOCTL_BLOCK_FORMAT
//
struct blk_format {
  unsigned int bf_fstype;
  unsigned int bf_spare[15];
};

/****************************************************************************************************************/
#endif
