#ifndef _CIPHER_MD5SUM_H_ /**************************************************************************************/
#define _CIPHER_MD5SUM_H_

#include <sys/types.h>

/****************************************************************************************************************/

struct md5_checksum {
  uint32 md5_state[4];		// MD5 checksum
  uint64 md5_count;		// number of bytes
  uint32 md5_buffer[16];	// input buffer
};

/****************************************************************************************************************/

// Feed it piece by piece
void md5_init(struct md5_checksum *md5);
void md5_calculate(struct md5_checksum *md5, const void *data, size_t len);
const void *md5_final(struct md5_checksum *md5);

// Do a full block
void md5_calculate_checksum(const void *data, size_t len, void *output);

// Unix compatible password hashing
char *md5_crypt_r(const char *pw, const char *salt, char *buffer, int bufsize);

extern const unsigned char md5_crypt_itoa64[64];

/****************************************************************************************************************/
#endif
