#ifndef _TT_DATE_H_
#define _TT_DATE_H_

/****************************************************************************************************************/

#include <sys/types.h>
#include <sys/cdefs.h>

/****************************************************************************************************************/

struct rtc_time {       // Basic time/date structure
  unsigned short year;
  unsigned char  month;
  unsigned char  day;
  unsigned char  hour;
  unsigned char  min;
  unsigned char  sec;
};

/****************************************************************************************************************/

__BEGIN_DECLS
int date2days(const struct rtc_time *rt);
void days2date(int days, struct rtc_time *rt);

time_t date2time(const struct rtc_time *rt);
void time2date(time_t time, struct rtc_time *rt);
__END_DECLS

/****************************************************************************************************************/
#endif
