#ifndef _TERMINAL_H_
#define _TERMINAL_H_

#include <sys/cdefs.h>

/****************************************************************************************************************/

struct terminal;
struct keyboard;
struct polltable;

__BEGIN_DECLS
struct terminal *terminal_init(struct pixmap *pm, struct font *font);
void terminal_free(struct terminal *trm);

// Cause screen update: Paint anything that has changed since last call (This is usually done automatically.)
void terminal_update(struct terminal *trm);

// Full screen redraw: Repaint the full terminal screen
void terminal_redraw(struct terminal *trm);

// Enable disable automatic update (Default is enabled)
void terminal_set_auto_update(struct terminal *trm, int enable);

void terminal_write(struct terminal *trm, const void *data, size_t bytes);
void terminal_puts(struct terminal *trm, const char *str);
void terminal_putc(struct terminal *trm, int ch);

typedef void terminal_respond_t(void *data, const void *response, size_t bytes);
void terminal_set_response_handler(struct terminal *trm, terminal_respond_t *handler, void *data);

void terminal_set_keyboard(struct terminal *trm, struct keyboard *kbd);
struct keyboard *terminal_init_keyboard(struct terminal *trm, struct polltable *ptab);

#define TERMINAL_COLOR_COUNT	24		// 8xNormal, 8xIntensity, 8xDim

struct terminal_colors {
  uint trc_colors[TERMINAL_COLOR_COUNT];	// Pixel values of colors
  uint trc_default_bgpixel;
  uint trc_default_fgpixel;
  uint trc_default_fgpixel_bright;
  uint trc_default_fgpixel_dim;
};

struct terminal_colors *terminal_colors(struct terminal *trm);
struct pixmap *terminal_pixmap(struct terminal *trm);
struct font *terminal_font(struct terminal *trm);

__END_DECLS

/****************************************************************************************************************/
#endif
