#ifndef _GEO_H_
#define _GEO_H_

#include <sys/types.h>
#include <sys/cdefs.h>

/****************************************************************************************************************/

struct point {
  int x;
  int y;
};

/****************************************************************************************************************/

struct size {
  uint w;
  uint h;
};

/****************************************************************************************************************/

struct rect {
  int x1;
  int y1;
  int x2;
  int y2;
};

/****************************************************************************************************************/

static __inline int rectangles_intersect(const struct rect *rect1, const struct rect *rect2) {
  return ((rect1->x2 >= rect2->x1) && (rect1->x1 <= rect2->x2) &&
	  (rect1->y2 >= rect2->y1) && (rect1->y1 <= rect2->y2));
}

/****************************************************************************************************************/

static __inline int point_in_rectangle(const struct rect *rect, int x, int y) {
  return ((x >= rect->x1) && (x <= rect->x2) && (y >= rect->y1) && (y <= rect->y2));
}

/****************************************************************************************************************/

__BEGIN_DECLS
void clip_rect(struct rect *rect, const struct rect *bounds);
__END_DECLS

/****************************************************************************************************************/
#endif
